-- Script para agregar funcionalidad de crédito a clientes
-- Fecha: 2025-11-13

USE pos_abarrotes;

-- Agregar campos de crédito a la tabla clientes
ALTER TABLE clientes
ADD COLUMN tiene_credito TINYINT(1) DEFAULT 0 COMMENT 'Indica si el cliente tiene crédito habilitado',
ADD COLUMN monto_credito_maximo DECIMAL(10,2) DEFAULT 0.00 COMMENT 'Monto máximo de crédito autorizado',
ADD COLUMN dias_credito INT DEFAULT 0 COMMENT 'Días de crédito (15, 30 o 45)',
ADD COLUMN saldo_credito_usado DECIMAL(10,2) DEFAULT 0.00 COMMENT 'Saldo actual de crédito utilizado';

-- Crear índice para consultas de clientes con crédito
CREATE INDEX idx_clientes_credito ON clientes(tiene_credito);

-- Comentarios sobre los campos
/*
tiene_credito: 0 = No tiene crédito, 1 = Tiene crédito habilitado
monto_credito_maximo: Límite de crédito autorizado para el cliente
dias_credito: Plazo estándar (15, 30 o 45 días)
saldo_credito_usado: Monto actual que el cliente debe (se actualiza con las ventas a crédito)
*/
