-- ================================
-- AGREGAR NOMBRE COMERCIAL A CLIENTES
-- ================================
-- Fecha: 2025-09-27
-- Descripción: Agregar campo nombre_comercial a la tabla clientes existente

-- Verificar si la columna ya existe antes de agregarla
SET @column_exists = (
    SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = 'pos_abarrotes'
    AND TABLE_NAME = 'clientes'
    AND COLUMN_NAME = 'nombre_comercial'
);

-- Agregar la columna solo si no existe
SET @sql = IF(@column_exists = 0,
    'ALTER TABLE clientes ADD COLUMN nombre_comercial VARCHAR(100) NULL AFTER apellido',
    'SELECT "La columna nombre_comercial ya existe" as mensaje'
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Verificar la estructura actualizada
DESCRIBE clientes;