-- ========================================
-- Script de Creación: Módulo de Almacenes
-- Sistema POS Abarrotes
-- ========================================

-- 1. Crear tabla almacenes
CREATE TABLE IF NOT EXISTS almacenes (
    id INT(11) NOT NULL AUTO_INCREMENT,
    nombre VARCHAR(100) NOT NULL,
    codigo VARCHAR(20) UNIQUE,
    activo TINYINT(4) DEFAULT 1,
    fecha_creacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    fecha_actualizacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    KEY idx_nombre (nombre),
    KEY idx_codigo (codigo),
    KEY idx_activo (activo)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 2. Agregar permiso para almacenes
INSERT INTO permisos (nombre, descripcion, modulo, accion, activo)
VALUES ('almacenes_ver', 'Acceso a Gestión de Almacenes', 'almacenes', 'ver', 1)
ON DUPLICATE KEY UPDATE descripcion = 'Acceso a Gestión de Almacenes';

-- 3. Asignar permiso al rol Administrador
INSERT INTO rol_permisos (rol_id, permiso_id)
SELECT r.id, p.id
FROM roles r, permisos p
WHERE r.nombre = 'Administrador' AND p.nombre = 'almacenes_ver'
AND NOT EXISTS (
    SELECT 1 FROM rol_permisos rp
    WHERE rp.rol_id = r.id AND rp.permiso_id = p.id
);

-- 4. (Opcional) Insertar almacén por defecto
INSERT INTO almacenes (nombre, codigo, activo)
VALUES ('Almacén Principal', 'ALM-001', 1)
ON DUPLICATE KEY UPDATE nombre = nombre;

-- ========================================
-- Verificación
-- ========================================
SELECT 'Tabla almacenes creada correctamente' AS resultado;
SELECT * FROM permisos WHERE nombre = 'almacenes_ver';
SELECT COUNT(*) AS total_almacenes FROM almacenes;
