-- ================================
-- CREACIÓN DE TABLAS DE VENTAS
-- ================================
-- Fecha: 2025-01-27
-- Descripción: Tablas para gestionar ventas y sus detalles

-- 1. TABLA VENTAS
CREATE TABLE IF NOT EXISTS ventas (
    id INT(11) NOT NULL AUTO_INCREMENT,
    folio VARCHAR(50) NOT NULL,
    cliente_id INT(11) NULL,
    cliente_nombre VARCHAR(255) NULL,
    usuario_id INT(11) NOT NULL,
    usuario_nombre VARCHAR(255) NOT NULL,
    subtotal DECIMAL(10, 2) NOT NULL DEFAULT 0.00,
    impuesto DECIMAL(10, 2) NOT NULL DEFAULT 0.00,
    descuento DECIMAL(10, 2) NOT NULL DEFAULT 0.00,
    total DECIMAL(10, 2) NOT NULL DEFAULT 0.00,
    metodo_pago ENUM('efectivo', 'tarjeta', 'transferencia', 'mixto') DEFAULT 'efectivo',
    estado ENUM('completada', 'pendiente', 'cancelada') DEFAULT 'completada',
    observaciones TEXT NULL,
    fecha_creacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    fecha_actualizacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    UNIQUE KEY unique_folio (folio),
    INDEX idx_cliente (cliente_id),
    INDEX idx_usuario (usuario_id),
    INDEX idx_estado (estado),
    INDEX idx_fecha (fecha_creacion),
    FOREIGN KEY (cliente_id) REFERENCES clientes(id) ON DELETE SET NULL,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 2. TABLA VENTA_DETALLES
CREATE TABLE IF NOT EXISTS venta_detalles (
    id INT(11) NOT NULL AUTO_INCREMENT,
    venta_id INT(11) NOT NULL,
    producto_id INT(11) NOT NULL,
    producto_nombre VARCHAR(255) NOT NULL,
    cantidad DECIMAL(10, 2) NOT NULL,
    precio_unitario DECIMAL(10, 2) NOT NULL,
    subtotal DECIMAL(10, 2) NOT NULL,
    impuesto DECIMAL(10, 2) NOT NULL DEFAULT 0.00,
    descuento DECIMAL(10, 2) NOT NULL DEFAULT 0.00,
    total DECIMAL(10, 2) NOT NULL,
    fecha_creacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    INDEX idx_venta (venta_id),
    INDEX idx_producto (producto_id),
    FOREIGN KEY (venta_id) REFERENCES ventas(id) ON DELETE CASCADE,
    FOREIGN KEY (producto_id) REFERENCES productos(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 3. AGREGAR CAMPOS A PRODUCTOS SI NO EXISTEN (para inventario)
ALTER TABLE productos
ADD COLUMN IF NOT EXISTS stock INT(11) DEFAULT 0 AFTER precio,
ADD COLUMN IF NOT EXISTS stock_minimo INT(11) DEFAULT 0 AFTER stock;

-- ================================
-- VERIFICACIÓN DE ESTRUCTURA
-- ================================
DESCRIBE ventas;
DESCRIBE venta_detalles;

-- Verificar índices
SHOW INDEX FROM ventas;
SHOW INDEX FROM venta_detalles;
