-- ================================
-- DATOS DE EJEMPLO PARA VENTAS
-- ================================
-- Fecha: 2025-01-27
-- Descripción: Inserta ventas de ejemplo para pruebas

-- Insertar ventas de ejemplo
INSERT INTO ventas (folio, cliente_id, cliente_nombre, usuario_id, usuario_nombre, subtotal, impuesto, descuento, total, metodo_pago, estado, observaciones) VALUES
('VTA-20250127-0001', 1, 'Ana Sofía', 1, 'Admin', 150.00, 0.00, 0.00, 150.00, 'efectivo', 'completada', 'Venta de prueba 1'),
('VTA-20250127-0002', 2, 'Carlos López', 1, 'Admin', 320.50, 0.00, 10.00, 310.50, 'tarjeta', 'completada', 'Venta de prueba 2'),
('VTA-20250127-0003', NULL, 'Cliente General', 1, 'Admin', 89.90, 0.00, 0.00, 89.90, 'efectivo', 'completada', 'Venta mostrador'),
('VTA-20250126-0001', 1, 'Ana Sofía', 1, 'Admin', 245.00, 0.00, 5.00, 240.00, 'transferencia', 'completada', 'Venta día anterior'),
('VTA-20250125-0001', NULL, 'Cliente General', 1, 'Admin', 567.80, 0.00, 0.00, 567.80, 'efectivo', 'completada', 'Venta hace 2 días');

-- Obtener IDs de ventas insertadas
SET @venta1 = (SELECT id FROM ventas WHERE folio = 'VTA-20250127-0001');
SET @venta2 = (SELECT id FROM ventas WHERE folio = 'VTA-20250127-0002');
SET @venta3 = (SELECT id FROM ventas WHERE folio = 'VTA-20250127-0003');
SET @venta4 = (SELECT id FROM ventas WHERE folio = 'VTA-20250126-0001');
SET @venta5 = (SELECT id FROM ventas WHERE folio = 'VTA-20250125-0001');

-- Insertar detalles de ventas (asumiendo que existen productos con IDs 1-5)
-- Venta 1 - 3 productos
INSERT INTO venta_detalles (venta_id, producto_id, producto_nombre, cantidad, precio_unitario, subtotal, impuesto, descuento, total) VALUES
(@venta1, 1, 'Producto Demo 1', 2, 25.00, 50.00, 0.00, 0.00, 50.00),
(@venta1, 2, 'Producto Demo 2', 3, 20.00, 60.00, 0.00, 0.00, 60.00),
(@venta1, 3, 'Producto Demo 3', 1, 40.00, 40.00, 0.00, 0.00, 40.00);

-- Venta 2 - 4 productos
INSERT INTO venta_detalles (venta_id, producto_id, producto_nombre, cantidad, precio_unitario, subtotal, impuesto, descuento, total) VALUES
(@venta2, 1, 'Producto Demo 1', 5, 25.00, 125.00, 0.00, 5.00, 120.00),
(@venta2, 2, 'Producto Demo 2', 4, 20.00, 80.00, 0.00, 0.00, 80.00),
(@venta2, 4, 'Producto Demo 4', 2, 45.00, 90.00, 0.00, 0.00, 90.00),
(@venta2, 5, 'Producto Demo 5', 1, 30.50, 30.50, 0.00, 5.00, 25.50);

-- Venta 3 - 2 productos
INSERT INTO venta_detalles (venta_id, producto_id, producto_nombre, cantidad, precio_unitario, subtotal, impuesto, descuento, total) VALUES
(@venta3, 3, 'Producto Demo 3', 1, 40.00, 40.00, 0.00, 0.00, 40.00),
(@venta3, 5, 'Producto Demo 5', 1, 49.90, 49.90, 0.00, 0.00, 49.90);

-- Venta 4 - 3 productos
INSERT INTO venta_detalles (venta_id, producto_id, producto_nombre, cantidad, precio_unitario, subtotal, impuesto, descuento, total) VALUES
(@venta4, 1, 'Producto Demo 1', 3, 25.00, 75.00, 0.00, 0.00, 75.00),
(@venta4, 2, 'Producto Demo 2', 5, 20.00, 100.00, 0.00, 0.00, 100.00),
(@venta4, 4, 'Producto Demo 4', 2, 37.50, 75.00, 0.00, 5.00, 70.00);

-- Venta 5 - 4 productos
INSERT INTO venta_detalles (venta_id, producto_id, producto_nombre, cantidad, precio_unitario, subtotal, impuesto, descuento, total) VALUES
(@venta5, 1, 'Producto Demo 1', 10, 25.00, 250.00, 0.00, 0.00, 250.00),
(@venta5, 2, 'Producto Demo 2', 8, 20.00, 160.00, 0.00, 0.00, 160.00),
(@venta5, 3, 'Producto Demo 3', 2, 40.00, 80.00, 0.00, 0.00, 80.00),
(@venta5, 5, 'Producto Demo 5', 3, 25.93, 77.80, 0.00, 0.00, 77.80);

-- Verificar datos insertados
SELECT 'Ventas insertadas:' as info, COUNT(*) as total FROM ventas;
SELECT 'Detalles insertados:' as info, COUNT(*) as total FROM venta_detalles;

-- Mostrar ventas con totales
SELECT
    v.folio,
    v.cliente_nombre,
    v.total,
    v.metodo_pago,
    v.estado,
    COUNT(vd.id) as productos,
    v.fecha_creacion
FROM ventas v
LEFT JOIN venta_detalles vd ON v.id = vd.venta_id
GROUP BY v.id
ORDER BY v.fecha_creacion DESC;
