-- ================================
-- DATOS DE EJEMPLO PARA VENTAS
-- ================================
-- Inserta ventas de ejemplo con datos reales

-- Venta 1 - Cliente 12 (Alex)
INSERT INTO ventas (folio, cliente_id, cliente_nombre, usuario_id, usuario_nombre, subtotal, impuesto, descuento, total, metodo_pago, estado, observaciones)
VALUES ('VTA-20250127-0001', 12, 'Alex', 1, 'Admin', 150.00, 0.00, 0.00, 150.00, 'efectivo', 'completada', 'Venta de prueba 1');

SET @venta1 = LAST_INSERT_ID();

INSERT INTO venta_detalles (venta_id, producto_id, producto_nombre, cantidad, precio_unitario, subtotal, impuesto, descuento, total) VALUES
(@venta1, 9, 'Coca Cola 600ml', 3, 18.00, 54.00, 0.00, 0.00, 54.00),
(@venta1, 10, 'Arroz Blanco 1kg', 2, 32.00, 64.00, 0.00, 0.00, 64.00),
(@venta1, 12, 'Leche Entera 1L', 1, 26.00, 26.00, 0.00, 0.00, 26.00),
(@venta1, 16, 'Azúcar Refinada 1kg', 1, 28.50, 28.50, 0.00, 0.00, 28.50);

UPDATE ventas SET subtotal = 172.50, total = 172.50 WHERE id = @venta1;

-- Venta 2 - Cliente 11 (victor)
INSERT INTO ventas (folio, cliente_id, cliente_nombre, usuario_id, usuario_nombre, subtotal, impuesto, descuento, total, metodo_pago, estado, observaciones)
VALUES ('VTA-20250127-0002', 11, 'victor', 1, 'Admin', 250.00, 0.00, 10.00, 240.00, 'tarjeta', 'completada', 'Compra grande con descuento');

SET @venta2 = LAST_INSERT_ID();

INSERT INTO venta_detalles (venta_id, producto_id, producto_nombre, cantidad, precio_unitario, subtotal, impuesto, descuento, total) VALUES
(@venta2, 11, 'Aceite de Cocina 1L', 2, 42.00, 84.00, 0.00, 0.00, 84.00),
(@venta2, 14, 'Detergente en Polvo 1kg', 2, 52.00, 104.00, 0.00, 10.00, 94.00),
(@venta2, 15, 'Huevos Blancos 18 piezas', 1, 62.00, 62.00, 0.00, 0.00, 62.00);

UPDATE ventas SET subtotal = 250.00, descuento = 10.00, total = 240.00 WHERE id = @venta2;

-- Venta 3 - Cliente General
INSERT INTO ventas (folio, cliente_id, cliente_nombre, usuario_id, usuario_nombre, subtotal, impuesto, descuento, total, metodo_pago, estado, observaciones)
VALUES ('VTA-20250127-0003', NULL, 'Cliente General', 1, 'Admin', 89.00, 0.00, 0.00, 89.00, 'efectivo', 'completada', 'Venta mostrador');

SET @venta3 = LAST_INSERT_ID();

INSERT INTO venta_detalles (venta_id, producto_id, producto_nombre, cantidad, precio_unitario, subtotal, impuesto, descuento, total) VALUES
(@venta3, 13, 'Pan de Caja Integral', 1, 31.00, 31.00, 0.00, 0.00, 31.00),
(@venta3, 17, 'Papel Higiénico 4 rollos', 1, 38.00, 38.00, 0.00, 0.00, 38.00),
(@venta3, 9, 'Coca Cola 600ml', 1, 18.00, 18.00, 0.00, 0.00, 18.00);

UPDATE ventas SET subtotal = 87.00, total = 87.00 WHERE id = @venta3;

-- Venta 4 - Día anterior
INSERT INTO ventas (folio, cliente_id, cliente_nombre, usuario_id, usuario_nombre, subtotal, impuesto, descuento, total, metodo_pago, estado, observaciones, fecha_creacion)
VALUES ('VTA-20250126-0001', 12, 'Alex', 1, 'Admin', 134.50, 0.00, 0.00, 134.50, 'transferencia', 'completada', 'Venta día anterior', DATE_SUB(NOW(), INTERVAL 1 DAY));

SET @venta4 = LAST_INSERT_ID();

INSERT INTO venta_detalles (venta_id, producto_id, producto_nombre, cantidad, precio_unitario, subtotal, impuesto, descuento, total) VALUES
(@venta4, 5, 'Aceite Capullo 1L', 2, 35.00, 70.00, 0.00, 0.00, 70.00),
(@venta4, 10, 'Arroz Blanco 1kg', 2, 32.00, 64.00, 0.00, 0.00, 64.00);

UPDATE ventas SET subtotal = 134.00, total = 134.00 WHERE id = @venta4;

-- Venta 5 - Hace 2 días
INSERT INTO ventas (folio, cliente_id, cliente_nombre, usuario_id, usuario_nombre, subtotal, impuesto, descuento, total, metodo_pago, estado, observaciones, fecha_creacion)
VALUES ('VTA-20250125-0001', NULL, 'Cliente General', 1, 'Admin', 350.50, 0.00, 0.00, 350.50, 'efectivo', 'completada', 'Venta hace 2 días', DATE_SUB(NOW(), INTERVAL 2 DAY));

SET @venta5 = LAST_INSERT_ID();

INSERT INTO venta_detalles (venta_id, producto_id, producto_nombre, cantidad, precio_unitario, subtotal, impuesto, descuento, total) VALUES
(@venta5, 9, 'Coca Cola 600ml', 10, 18.00, 180.00, 0.00, 0.00, 180.00),
(@venta5, 15, 'Huevos Blancos 18 piezas', 2, 62.00, 124.00, 0.00, 0.00, 124.00),
(@venta5, 13, 'Pan de Caja Integral', 1, 31.00, 31.00, 0.00, 0.00, 31.00);

UPDATE ventas SET subtotal = 335.00, total = 335.00 WHERE id = @venta5;

-- Verificar datos insertados
SELECT 'Ventas insertadas:' as info, COUNT(*) as total FROM ventas;
SELECT 'Detalles insertados:' as info, COUNT(*) as total FROM venta_detalles;
