-- Migración: Agregar campo cantidad_escaneada a venta_detalles
-- Fecha: 2025-11-16
-- Descripción: Permite trackear cuántas unidades se han escaneado de cada producto

USE pos_abarrotes;

-- 1. Agregar campo cantidad_escaneada
ALTER TABLE venta_detalles
ADD COLUMN cantidad_escaneada INT NOT NULL DEFAULT 0
AFTER estatus_preparacion;

-- 2. Agregar índice para búsquedas rápidas
ALTER TABLE venta_detalles
ADD INDEX idx_cantidad_escaneada (cantidad_escaneada);

-- 3. Actualizar registros existentes que ya están preparados (marcar cantidad completa)
UPDATE venta_detalles
SET cantidad_escaneada = cantidad
WHERE estatus_preparacion = 'preparado';

-- Verificar cambios
DESCRIBE venta_detalles;

-- Mostrar algunos registros de ejemplo
SELECT vd.id, vd.venta_id, vd.producto_id, vd.cantidad, vd.cantidad_escaneada, vd.estatus_preparacion, p.nombre as producto_nombre
FROM venta_detalles vd
LEFT JOIN productos p ON vd.producto_id = p.id
LIMIT 5;
