-- Migración: Agregar campo estatus_pago y actualizar metodo_pago
-- Fecha: 2024-11-16
-- Descripción: Agrega campo para controlar el estatus de pago (pagado/pendiente)
--              y actualiza las opciones de método de pago para incluir 'credito'

USE pos_abarrotes;

-- 1. Agregar campo estatus_pago
ALTER TABLE ventas
ADD COLUMN estatus_pago ENUM('pagado', 'pendiente') NOT NULL DEFAULT 'pendiente'
AFTER metodo_pago;

-- 2. Actualizar el enum de metodo_pago para incluir 'credito'
ALTER TABLE ventas
MODIFY COLUMN metodo_pago ENUM('efectivo', 'tarjeta', 'transferencia', 'credito', 'mixto')
DEFAULT 'efectivo';

-- 3. Agregar índice para búsquedas rápidas por estatus de pago
ALTER TABLE ventas
ADD INDEX idx_estatus_pago (estatus_pago);

-- Verificar cambios
DESCRIBE ventas;

-- Mostrar algunos registros de ejemplo
SELECT id, folio, metodo_pago, estatus_pago, total, fecha_creacion
FROM ventas
ORDER BY id DESC
LIMIT 5;
