-- Migración: Agregar campo estatus_preparacion a venta_detalles
-- Fecha: 2025-11-16
-- Descripción: Permite trackear el estatus de preparación de cada producto individualmente

USE pos_abarrotes;

-- 1. Agregar campo estatus_preparacion
ALTER TABLE venta_detalles
ADD COLUMN estatus_preparacion ENUM('pendiente', 'preparado') NOT NULL DEFAULT 'pendiente'
AFTER cantidad;

-- 2. Agregar índice para búsquedas rápidas
ALTER TABLE venta_detalles
ADD INDEX idx_estatus_preparacion (estatus_preparacion);

-- Verificar cambios
DESCRIBE venta_detalles;

-- Mostrar algunos registros de ejemplo
SELECT vd.id, vd.venta_id, vd.producto_id, vd.cantidad, vd.estatus_preparacion, p.nombre as producto_nombre
FROM venta_detalles vd
LEFT JOIN productos p ON vd.producto_id = p.id
LIMIT 5;
