-- ============================================================
-- Script: Agregar Permiso gestion_usuarios_ver
-- Fecha: 2025-11-08
-- Descripción: Agrega el permiso para el grupo "Gestión de Usuarios"
--              en el Sidebar y lo asigna al rol Administrador
-- ============================================================

USE pos_abarrotes;

-- Verificar estado antes de la inserción
SELECT 'Estado ANTES de agregar el permiso:' as Info;
SELECT nombre, modulo FROM permisos WHERE nombre = 'gestion_usuarios_ver';

-- ============================================================
-- 1. Agregar permiso gestion_usuarios_ver
-- ============================================================
INSERT INTO permisos (nombre, modulo, descripcion, activo, fecha_creacion)
SELECT 'gestion_usuarios_ver', 'usuarios', 'Acceso al grupo de Gestión de Usuarios en el menú', 1, NOW()
WHERE NOT EXISTS (
    SELECT 1 FROM permisos WHERE nombre = 'gestion_usuarios_ver'
);

-- Verificar que el permiso se agregó
SELECT 'Permiso agregado:' as Info;
SELECT id, nombre, modulo, descripcion
FROM permisos
WHERE nombre = 'gestion_usuarios_ver';

-- ============================================================
-- 2. Asignar permiso al rol Administrador (ID = 1)
-- ============================================================
INSERT INTO rol_permisos (rol_id, permiso_id)
SELECT 1, p.id
FROM permisos p
WHERE p.nombre = 'gestion_usuarios_ver'
AND NOT EXISTS (
    SELECT 1 FROM rol_permisos rp
    WHERE rp.rol_id = 1 AND rp.permiso_id = p.id
);

-- Verificar la asignación
SELECT 'Permiso asignado al rol Administrador:' as Info;
SELECT r.id as rol_id, r.nombre as rol_nombre, p.id as permiso_id, p.nombre as permiso_nombre
FROM rol_permisos rp
JOIN roles r ON rp.rol_id = r.id
JOIN permisos p ON rp.permiso_id = p.id
WHERE r.id = 1 AND p.nombre = 'gestion_usuarios_ver';

-- ============================================================
-- 3. Mostrar todos los permisos del módulo usuarios
-- ============================================================
SELECT 'Todos los permisos del módulo usuarios:' as Info;
SELECT id, nombre, descripcion
FROM permisos
WHERE modulo = 'usuarios' AND activo = 1
ORDER BY nombre;

-- ============================================================
-- Resultado esperado:
-- - Se agrega el permiso: gestion_usuarios_ver
-- - Se asigna al rol Administrador (rol_id = 1)
-- - Total de permisos en módulo usuarios: 3
--   1. gestion_usuarios_ver
--   2. roles_ver
--   3. usuarios_ver
-- ============================================================
