-- ============================================================
-- Script: Agregar Permisos Faltantes del Sidebar
-- Fecha: 2025-11-08
-- Descripción: Agrega permisos referenciados en Sidebar.js
--              pero que no existen en la tabla permisos
-- ============================================================

USE pos_abarrotes;

-- Verificar permisos faltantes antes de insertar
SELECT 'Permisos antes de la inserción:' as Info;
SELECT nombre, modulo FROM permisos WHERE nombre IN ('categorias_ver', 'proveedores_ver');

-- ============================================================
-- 1. Permiso: categorias_ver
-- Ubicación en Sidebar: Productos > Categorías
-- ============================================================
INSERT INTO permisos (nombre, modulo, descripcion, activo, fecha_creacion)
SELECT 'categorias_ver', 'productos', 'Acceso a Gestión de Categorías de Productos', 1, NOW()
WHERE NOT EXISTS (
    SELECT 1 FROM permisos WHERE nombre = 'categorias_ver'
);

-- ============================================================
-- 2. Permiso: proveedores_ver
-- Ubicación en Sidebar: Productos > Proveedores
-- ============================================================
INSERT INTO permisos (nombre, modulo, descripcion, activo, fecha_creacion)
SELECT 'proveedores_ver', 'productos', 'Acceso a Gestión de Proveedores', 1, NOW()
WHERE NOT EXISTS (
    SELECT 1 FROM permisos WHERE nombre = 'proveedores_ver'
);

-- Verificar permisos después de insertar
SELECT 'Permisos después de la inserción:' as Info;
SELECT nombre, modulo, descripcion, activo
FROM permisos
WHERE nombre IN ('categorias_ver', 'proveedores_ver');

-- Mostrar todos los permisos del módulo productos
SELECT 'Todos los permisos del módulo productos:' as Info;
SELECT nombre, descripcion
FROM permisos
WHERE modulo = 'productos' AND activo = 1
ORDER BY nombre;

-- ============================================================
-- Resultado esperado:
-- - Se agregan 2 nuevos permisos: categorias_ver y proveedores_ver
-- - Ambos bajo el módulo 'productos'
-- - Total de permisos en BD: 21 (antes: 19, agregados: 2)
-- ============================================================
