-- ========================================
-- Tabla: usuario_almacenes
-- Descripción: Relación many-to-many entre usuarios y almacenes
-- Sistema POS Abarrotes
-- Fecha: 2025-11-08
-- ========================================

CREATE TABLE IF NOT EXISTS `usuario_almacenes` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `usuario_id` INT(11) NOT NULL,
  `almacen_id` INT(11) NOT NULL,
  `fecha_asignacion` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_usuario_almacen` (`usuario_id`, `almacen_id`),
  KEY `idx_usuario_id` (`usuario_id`),
  KEY `idx_almacen_id` (`almacen_id`),
  CONSTRAINT `fk_usuario_almacenes_usuario`
    FOREIGN KEY (`usuario_id`)
    REFERENCES `usuarios` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_usuario_almacenes_almacen`
    FOREIGN KEY (`almacen_id`)
    REFERENCES `almacenes` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ========================================
-- Índices para optimización de consultas
-- ========================================

-- Índice para buscar almacenes de un usuario
CREATE INDEX `idx_usuario_almacenes_lookup` ON `usuario_almacenes` (`usuario_id`, `almacen_id`);

-- ========================================
-- Comentarios de tabla y columnas
-- ========================================

ALTER TABLE `usuario_almacenes`
  COMMENT = 'Tabla de relación entre usuarios y almacenes asignados';

-- ========================================
-- Datos de ejemplo (opcional - comentar si no se necesita)
-- ========================================

/*
-- Ejemplo: Asignar almacenes a usuarios existentes
INSERT INTO usuario_almacenes (usuario_id, almacen_id) VALUES
(1, 1), -- Usuario 1 asignado a Almacén 1
(1, 2), -- Usuario 1 asignado a Almacén 2
(2, 1); -- Usuario 2 asignado a Almacén 1
*/
