-- ================================
-- MODIFICACIONES MÓDULO CLIENTES
-- ================================
-- Fecha: 2025-09-27
-- Descripción: Agregar soporte para múltiples teléfonos y direcciones

-- 1. AGREGAR NOMBRE COMERCIAL Y ELIMINAR CAMPOS
-- Agregar nombre comercial si no existe
ALTER TABLE clientes
ADD COLUMN IF NOT EXISTS nombre_comercial VARCHAR(100) AFTER apellido;

-- Eliminar campos que ya no se usarán (incluyendo apellido y fecha_nacimiento)
ALTER TABLE clientes
DROP COLUMN IF EXISTS rfc,
DROP COLUMN IF EXISTS email,
DROP COLUMN IF EXISTS apellido,
DROP COLUMN IF EXISTS fecha_nacimiento;

-- 2. CREAR TABLA PARA MÚLTIPLES TELÉFONOS
CREATE TABLE cliente_telefonos (
    id INT(11) NOT NULL AUTO_INCREMENT,
    cliente_id INT(11) NOT NULL,
    telefono VARCHAR(15) NOT NULL,
    tipo ENUM('principal', 'casa', 'trabajo', 'otro') DEFAULT 'principal',
    activo TINYINT(4) DEFAULT 1,
    fecha_creacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    fecha_actualizacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    FOREIGN KEY (cliente_id) REFERENCES clientes(id) ON DELETE CASCADE,
    INDEX idx_cliente_telefono (cliente_id, activo),
    INDEX idx_telefono (telefono),
    UNIQUE KEY unique_cliente_telefono (cliente_id, telefono)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 3. CREAR TABLA PARA MÚLTIPLES DIRECCIONES
CREATE TABLE cliente_direcciones (
    id INT(11) NOT NULL AUTO_INCREMENT,
    cliente_id INT(11) NOT NULL,
    direccion TEXT NOT NULL,
    tipo ENUM('principal', 'entrega', 'facturacion', 'otro') DEFAULT 'principal',
    activo TINYINT(4) DEFAULT 1,
    fecha_creacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    fecha_actualizacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    FOREIGN KEY (cliente_id) REFERENCES clientes(id) ON DELETE CASCADE,
    INDEX idx_cliente_direccion (cliente_id, activo)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 4. MIGRAR DATOS EXISTENTES (si los hay)
-- Migrar teléfonos existentes a la nueva tabla
INSERT INTO cliente_telefonos (cliente_id, telefono, tipo, activo)
SELECT id, telefono, 'principal', activo
FROM clientes
WHERE telefono IS NOT NULL AND telefono != '';

-- Migrar direcciones existentes a la nueva tabla
INSERT INTO cliente_direcciones (cliente_id, direccion, tipo, activo)
SELECT id, direccion, 'principal', activo
FROM clientes
WHERE direccion IS NOT NULL AND direccion != '';

-- 5. ELIMINAR COLUMNAS MIGRADAS
ALTER TABLE clientes
DROP COLUMN telefono,
DROP COLUMN direccion;

-- ================================
-- VERIFICACIÓN DE ESTRUCTURA
-- ================================
-- Verificar estructura final de clientes
DESCRIBE clientes;

-- Verificar nuevas tablas
DESCRIBE cliente_telefonos;
DESCRIBE cliente_direcciones;

-- Contar registros migrados
SELECT 'Clientes' as tabla, COUNT(*) as total FROM clientes
UNION ALL
SELECT 'Teléfonos', COUNT(*) FROM cliente_telefonos
UNION ALL
SELECT 'Direcciones', COUNT(*) FROM cliente_direcciones;