-- Script para agregar permisos del módulo de Catálogos
-- Sistema POS Abarrotes

-- ================================================
-- AGREGAR PERMISOS DE CATÁLOGOS
-- ================================================

-- Insertar permisos de catálogos
INSERT INTO permisos (nombre, descripcion, modulo, accion, activo)
VALUES
    ('catalogos_ver', 'Acceso al módulo de Catálogos', 'catalogos', 'ver', 1),
    ('almacen_ver', 'Acceso al Catálogo de Almacén', 'catalogos', 'ver', 1),
    ('pikeng_ver', 'Acceso a Pikeng en Almacén', 'catalogos', 'ver', 1),
    ('logistica_ver', 'Acceso al Catálogo de Logística', 'catalogos', 'ver', 1),
    ('medido_hoy_ver', 'Acceso a Medido hoy en Logística', 'catalogos', 'ver', 1);

-- ================================================
-- ASIGNAR PERMISOS AL ROL ADMINISTRADOR
-- ================================================

-- Asignar permisos de catálogos al rol Administrador
INSERT INTO rol_permisos (rol_id, permiso_id)
SELECT r.id, p.id
FROM roles r, permisos p
WHERE r.nombre = 'Administrador'
AND p.nombre IN ('catalogos_ver', 'almacen_ver', 'pikeng_ver', 'logistica_ver', 'medido_hoy_ver');

-- ================================================
-- OPCIONAL: ASIGNAR A OTROS ROLES
-- ================================================

-- Descomentar las siguientes líneas si deseas asignar los permisos a otros roles

-- Asignar a Gerente (si existe)
-- INSERT INTO rol_permisos (rol_id, permiso_id)
-- SELECT r.id, p.id
-- FROM roles r, permisos p
-- WHERE r.nombre = 'Gerente'
-- AND p.nombre IN ('catalogos_ver', 'almacen_ver', 'pikeng_ver', 'logistica_ver', 'medido_hoy_ver');

-- ================================================
-- VERIFICACIÓN
-- ================================================

-- Consultar los permisos creados
SELECT * FROM permisos WHERE modulo = 'catalogos' ORDER BY nombre;

-- Consultar asignaciones de los permisos a roles
SELECT
    r.nombre as rol,
    p.nombre as permiso,
    p.descripcion
FROM rol_permisos rp
INNER JOIN roles r ON rp.rol_id = r.id
INNER JOIN permisos p ON rp.permiso_id = p.id
WHERE p.modulo = 'catalogos'
ORDER BY r.nombre, p.nombre;
