-- Script para agregar permisos del módulo de Reportes de Ventas
-- Sistema POS Abarrotes

-- ================================================
-- AGREGAR PERMISO PARA REPORTES
-- ================================================

-- Insertar permiso de reportes
INSERT INTO permisos (nombre, descripcion, modulo, accion, activo)
VALUES ('reportes_ventas_ver', 'Acceso a Reportes de Ventas', 'reportes', 'ver', 1);

-- ================================================
-- ASIGNAR PERMISO AL ROL ADMINISTRADOR
-- ================================================

-- Asignar permiso de reportes al rol Administrador
INSERT INTO rol_permisos (rol_id, permiso_id)
SELECT r.id, p.id
FROM roles r, permisos p
WHERE r.nombre = 'Administrador' AND p.nombre = 'reportes_ventas_ver';

-- ================================================
-- OPCIONAL: ASIGNAR A OTROS ROLES
-- ================================================

-- Descomentar las siguientes líneas si deseas asignar el permiso a otros roles

-- Asignar a Gerente (si existe)
-- INSERT INTO rol_permisos (rol_id, permiso_id)
-- SELECT r.id, p.id
-- FROM roles r, permisos p
-- WHERE r.nombre = 'Gerente' AND p.nombre = 'reportes_ventas_ver';

-- Asignar a Supervisor (si existe)
-- INSERT INTO rol_permisos (rol_id, permiso_id)
-- SELECT r.id, p.id
-- FROM roles r, permisos p
-- WHERE r.nombre = 'Supervisor' AND p.nombre = 'reportes_ventas_ver';

-- ================================================
-- VERIFICACIÓN
-- ================================================

-- Consultar el permiso creado
SELECT * FROM permisos WHERE nombre = 'reportes_ventas_ver';

-- Consultar asignaciones del permiso a roles
SELECT
    r.nombre as rol,
    p.nombre as permiso,
    p.descripcion
FROM rol_permisos rp
INNER JOIN roles r ON rp.rol_id = r.id
INNER JOIN permisos p ON rp.permiso_id = p.id
WHERE p.nombre = 'reportes_ventas_ver';
