-- Script para agregar permisos del submenú de Ventas
-- Sistema POS Abarrotes

-- ================================================
-- AGREGAR PERMISOS DE VENTAS
-- ================================================

-- Insertar permisos para el submenú de ventas
INSERT INTO permisos (nombre, descripcion, modulo, accion, activo)
VALUES
    ('ventas_mostrador_ver', 'Acceso a Ventas de Mostrador', 'ventas', 'ver', 1),
    ('pedidos_ver', 'Acceso a Pedidos', 'ventas', 'ver', 1);

-- ================================================
-- ASIGNAR PERMISOS AL ROL ADMINISTRADOR
-- ================================================

-- Asignar permisos de ventas al rol Administrador
INSERT INTO rol_permisos (rol_id, permiso_id)
SELECT r.id, p.id
FROM roles r, permisos p
WHERE r.nombre = 'Administrador'
AND p.nombre IN ('ventas_mostrador_ver', 'pedidos_ver');

-- ================================================
-- OPCIONAL: ASIGNAR A OTROS ROLES
-- ================================================

-- Descomentar las siguientes líneas si deseas asignar los permisos a otros roles

-- Asignar a Cajero (si existe)
-- INSERT INTO rol_permisos (rol_id, permiso_id)
-- SELECT r.id, p.id
-- FROM roles r, permisos p
-- WHERE r.nombre = 'Cajero'
-- AND p.nombre IN ('ventas_mostrador_ver', 'pedidos_ver');

-- Asignar a Vendedor (si existe)
-- INSERT INTO rol_permisos (rol_id, permiso_id)
-- SELECT r.id, p.id
-- FROM roles r, permisos p
-- WHERE r.nombre = 'Vendedor'
-- AND p.nombre IN ('ventas_mostrador_ver', 'pedidos_ver');

-- ================================================
-- VERIFICACIÓN
-- ================================================

-- Consultar los permisos creados
SELECT * FROM permisos WHERE nombre IN ('ventas_mostrador_ver', 'pedidos_ver') ORDER BY nombre;

-- Consultar asignaciones de los permisos a roles
SELECT
    r.nombre as rol,
    p.nombre as permiso,
    p.descripcion
FROM rol_permisos rp
INNER JOIN roles r ON rp.rol_id = r.id
INNER JOIN permisos p ON rp.permiso_id = p.id
WHERE p.nombre IN ('ventas_mostrador_ver', 'pedidos_ver')
ORDER BY r.nombre, p.nombre;
