<?php
// Script de debug para verificar login
require_once('./reportes/funciones_php/connect.php');
require_once('./vendor/EncryptClass.php');

$myencrypt = new EncryptClass();

// Verificar si el usuario admin existe
$query = "SELECT u.*, r.nombre as rol_nombre FROM usuarios u LEFT JOIN roles r ON u.rol_id = r.id WHERE u.usuario = 'admin'";
$result = $conn->query($query);

echo "<h2>Debug de Login - Usuario Admin</h2>";

if ($result && $row = $result->fetch_assoc()) {
    echo "<h3>✅ Usuario encontrado:</h3>";
    echo "<pre>";
    print_r($row);
    echo "</pre>";

    // Verificar password
    $password = 'admin123';
    $stored_hash = $row['password'];

    echo "<h3>🔐 Verificación de Password:</h3>";
    echo "Password ingresada: <strong>$password</strong><br>";
    echo "Hash almacenado: <strong>$stored_hash</strong><br>";

    $verify_result = $myencrypt->verifyPassword($password, $stored_hash);
    echo "Resultado de verificación: <strong>" . ($verify_result ? "✅ CORRECTO" : "❌ INCORRECTO") . "</strong><br>";

    // Generar nuevo hash
    $new_hash = $myencrypt->hashPassword($password);
    echo "<h3>🔄 Nuevo hash para admin123:</h3>";
    echo "Nuevo hash: <code>$new_hash</code><br>";
    echo "<h4>Query para actualizar:</h4>";
    echo "<code>UPDATE usuarios SET password = '$new_hash' WHERE usuario = 'admin';</code>";

} else {
    echo "<h3>❌ Usuario NO encontrado</h3>";
    echo "Verificando si existe algún usuario en la tabla...<br>";

    $query = "SELECT COUNT(*) as total FROM usuarios";
    $result = $conn->query($query);
    $count = $result->fetch_assoc();

    echo "Total de usuarios en la tabla: " . $count['total'] . "<br>";

    if ($count['total'] > 0) {
        echo "<h4>Usuarios existentes:</h4>";
        $query = "SELECT usuario, nombre, email FROM usuarios";
        $result = $conn->query($query);
        while ($row = $result->fetch_assoc()) {
            echo "- Usuario: {$row['usuario']}, Nombre: {$row['nombre']}, Email: {$row['email']}<br>";
        }
    }
}

echo "<hr>";
echo "<h3>📊 Estado de la Base de Datos:</h3>";
echo "Conexión: " . ($conn ? "✅ Conectada" : "❌ Error") . "<br>";
echo "Base de datos: pos_abarrotes<br>";
echo "Fecha: " . date('Y-m-d H:i:s') . "<br>";
?>