<?php
// ========================================
// Módulo: Almacenes
// Sistema POS Abarrotes
// ========================================

// Prevenir acceso directo
if (!defined('BASEPATH')) exit('No direct script access allowed');

switch ($tipo) {
    case 'getAlmacenes':
        try {
            $query = "SELECT id, nombre, codigo, activo, fecha_creacion, fecha_actualizacion
                     FROM almacenes
                     WHERE activo = 1
                     ORDER BY nombre ASC";

            $result = $conn->query($query);
            if (!$result) {
                sendResponse(false, "Error en consulta: " . $conn->error);
                break;
            }

            $almacenes = [];
            while ($row = $result->fetch_assoc()) {
                $almacenes[] = [
                    'id' => intval($row['id']),
                    'nombre' => $row['nombre'],
                    'codigo' => $row['codigo'],
                    'activo' => intval($row['activo']),
                    'fecha_creacion' => $row['fecha_creacion'],
                    'fecha_actualizacion' => $row['fecha_actualizacion']
                ];
            }

            sendResponse(true, "Almacenes obtenidos correctamente", $almacenes);
        } catch (Exception $e) {
            error_log("Error al obtener almacenes: " . $e->getMessage());
            sendResponse(false, "Error al obtener almacenes");
        }
        break;

    case 'crearAlmacen':
        try {
            $nombre = isset($datapost['nombre']) ? trim($datapost['nombre']) : '';
            $codigo = isset($datapost['codigo']) ? trim($datapost['codigo']) : '';
            $activo = isset($datapost['activo']) ? intval($datapost['activo']) : 1;

            // Validaciones
            if (empty($nombre)) {
                sendResponse(false, "El nombre del almacén es requerido");
                break;
            }

            // Verificar si el código ya existe
            if (!empty($codigo)) {
                $checkQuery = "SELECT id FROM almacenes WHERE codigo = ? AND activo = 1";
                $stmt = $conn->prepare($checkQuery);
                $stmt->bind_param("s", $codigo);
                $stmt->execute();
                $result = $stmt->get_result();
                if ($result->num_rows > 0) {
                    sendResponse(false, "Ya existe un almacén con ese código");
                    break;
                }
            }

            $query = "INSERT INTO almacenes (nombre, codigo, activo)
                     VALUES (?, ?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssi", $nombre, $codigo, $activo);

            if ($stmt->execute()) {
                sendResponse(true, "Almacén creado correctamente", ['id' => $conn->insert_id]);
            } else {
                sendResponse(false, "Error al crear almacén: " . $stmt->error);
            }
        } catch (Exception $e) {
            error_log("Error al crear almacén: " . $e->getMessage());
            sendResponse(false, "Error al crear almacén");
        }
        break;

    case 'actualizarAlmacen':
        try {
            $id = isset($datapost['id']) ? intval($datapost['id']) : 0;
            $nombre = isset($datapost['nombre']) ? trim($datapost['nombre']) : '';
            $codigo = isset($datapost['codigo']) ? trim($datapost['codigo']) : '';
            $activo = isset($datapost['activo']) ? intval($datapost['activo']) : 1;

            if ($id <= 0 || empty($nombre)) {
                sendResponse(false, "ID y nombre son requeridos");
                break;
            }

            // Verificar si el código ya existe en otro almacén
            if (!empty($codigo)) {
                $checkQuery = "SELECT id FROM almacenes WHERE codigo = ? AND id != ? AND activo = 1";
                $stmt = $conn->prepare($checkQuery);
                $stmt->bind_param("si", $codigo, $id);
                $stmt->execute();
                $result = $stmt->get_result();
                if ($result->num_rows > 0) {
                    sendResponse(false, "Ya existe otro almacén con ese código");
                    break;
                }
            }

            $query = "UPDATE almacenes SET nombre = ?, codigo = ?, activo = ?,
                     fecha_actualizacion = CURRENT_TIMESTAMP
                     WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssii", $nombre, $codigo, $activo, $id);

            if ($stmt->execute()) {
                sendResponse(true, "Almacén actualizado correctamente");
            } else {
                sendResponse(false, "Error al actualizar almacén: " . $stmt->error);
            }
        } catch (Exception $e) {
            error_log("Error al actualizar almacén: " . $e->getMessage());
            sendResponse(false, "Error al actualizar almacén");
        }
        break;

    case 'eliminarAlmacen':
        try {
            $id = isset($datapost['id']) ? intval($datapost['id']) : 0;

            if ($id <= 0) {
                sendResponse(false, "ID del almacén requerido");
                break;
            }

            // Soft delete - solo marcar como inactivo
            $query = "UPDATE almacenes SET activo = 0, fecha_actualizacion = CURRENT_TIMESTAMP WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $id);

            if ($stmt->execute()) {
                sendResponse(true, "Almacén desactivado correctamente");
            } else {
                sendResponse(false, "Error al desactivar almacén: " . $stmt->error);
            }
        } catch (Exception $e) {
            error_log("Error al eliminar almacén: " . $e->getMessage());
            sendResponse(false, "Error al eliminar almacén");
        }
        break;

    case 'getAlmacenById':
        try {
            $id = isset($datapost['id']) ? intval($datapost['id']) : 0;

            if ($id <= 0) {
                sendResponse(false, "ID del almacén requerido");
                break;
            }

            $query = "SELECT id, nombre, codigo, activo, fecha_creacion, fecha_actualizacion
                     FROM almacenes
                     WHERE id = ?";

            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $almacen = $result->fetch_assoc();
                $almacen['activo'] = (bool)$almacen['activo'];
                sendResponse(true, "Almacén obtenido correctamente", $almacen);
            } else {
                sendResponse(false, "Almacén no encontrado");
            }
        } catch (Exception $e) {
            error_log("Error al obtener almacén: " . $e->getMessage());
            sendResponse(false, "Error al obtener almacén");
        }
        break;

    default:
        sendResponse(false, "Operación no válida para almacenes");
        break;
}
?>
