<?php
// Prevenir acceso directo
if (!defined('BASEPATH')) exit('No direct script access allowed');

switch ($tipo) {
    case 'getCategorias':
        try {
            $query = "SELECT
                c.id,
                c.nombre,
                c.activo,
                c.fecha_creacion,
                c.fecha_actualizacion,
                COUNT(p.id) as productos_count
            FROM categorias c
            LEFT JOIN productos p ON c.id = p.categoria_id
            GROUP BY c.id, c.nombre, c.activo, c.fecha_creacion, c.fecha_actualizacion
            ORDER BY c.nombre ASC";

            $result = $conn->query($query);
            $categorias = [];

            while ($row = $result->fetch_assoc()) {
                $categorias[] = [
                    'id' => intval($row['id']),
                    'nombre' => $row['nombre'],
                    'activo' => intval($row['activo']),
                    'productos_count' => intval($row['productos_count']),
                    'fecha_creacion' => $row['fecha_creacion'],
                    'fecha_actualizacion' => $row['fecha_actualizacion']
                ];
            }

            sendResponse(true, "Categorías obtenidas exitosamente", $categorias);

        } catch (Exception $e) {
            sendResponse(false, "Error al obtener categorías: " . $e->getMessage());
        }
        break;

    case 'getCategoria':
        $id = intval($datapost['id'] ?? 0);

        if ($id <= 0) {
            sendResponse(false, "ID de categoría requerido");
        }

        try {
            $query = "SELECT
                c.id,
                c.nombre,
                c.activo,
                c.fecha_creacion,
                c.fecha_actualizacion,
                COUNT(p.id) as productos_count
            FROM categorias c
            LEFT JOIN productos p ON c.id = p.categoria_id
            WHERE c.id = ?
            GROUP BY c.id, c.nombre, c.activo, c.fecha_creacion, c.fecha_actualizacion";

            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($row = $result->fetch_assoc()) {
                $categoria = [
                    'id' => intval($row['id']),
                    'nombre' => $row['nombre'],
                    'activo' => intval($row['activo']),
                    'productos_count' => intval($row['productos_count']),
                    'fecha_creacion' => $row['fecha_creacion'],
                    'fecha_actualizacion' => $row['fecha_actualizacion']
                ];
                sendResponse(true, "Categoría obtenida exitosamente", $categoria);
            } else {
                sendResponse(false, "Categoría no encontrada");
            }

        } catch (Exception $e) {
            sendResponse(false, "Error al obtener categoría: " . $e->getMessage());
        }
        break;

    case 'crearCategoria':
        $nombre = trim($datapost['nombre'] ?? '');
        $activo = isset($datapost['activo']) ? intval($datapost['activo']) : 1;

        if (empty($nombre)) {
            sendResponse(false, "El nombre de la categoría es requerido");
        }

        if (strlen($nombre) < 2) {
            sendResponse(false, "El nombre debe tener al menos 2 caracteres");
        }

        if (strlen($nombre) > 50) {
            sendResponse(false, "El nombre no puede exceder 50 caracteres");
        }

        try {
            // Verificar si ya existe una categoría con el mismo nombre
            $checkQuery = "SELECT id FROM categorias WHERE nombre = ?";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("s", $nombre);
            $checkStmt->execute();

            if ($checkStmt->get_result()->num_rows > 0) {
                sendResponse(false, "Ya existe una categoría con ese nombre");
            }

            // Crear la categoría
            $query = "INSERT INTO categorias (nombre, activo) VALUES (?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("si", $nombre, $activo);

            if ($stmt->execute()) {
                $categoria_id = $conn->insert_id;
                sendResponse(true, "Categoría creada exitosamente", ['id' => $categoria_id]);
            } else {
                sendResponse(false, "Error al crear la categoría");
            }

        } catch (Exception $e) {
            sendResponse(false, "Error al crear categoría: " . $e->getMessage());
        }
        break;

    case 'actualizarCategoria':
        $id = intval($datapost['id'] ?? 0);
        $nombre = trim($datapost['nombre'] ?? '');
        $activo = isset($datapost['activo']) ? intval($datapost['activo']) : 1;

        if ($id <= 0) {
            sendResponse(false, "ID de categoría requerido");
        }

        if (empty($nombre)) {
            sendResponse(false, "El nombre de la categoría es requerido");
        }

        if (strlen($nombre) < 2) {
            sendResponse(false, "El nombre debe tener al menos 2 caracteres");
        }

        if (strlen($nombre) > 50) {
            sendResponse(false, "El nombre no puede exceder 50 caracteres");
        }

        try {
            // Verificar que la categoría existe
            $checkQuery = "SELECT id FROM categorias WHERE id = ?";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("i", $id);
            $checkStmt->execute();

            if ($checkStmt->get_result()->num_rows === 0) {
                sendResponse(false, "Categoría no encontrada");
            }

            // Verificar si ya existe otra categoría con el mismo nombre
            $checkNameQuery = "SELECT id FROM categorias WHERE nombre = ? AND id != ?";
            $checkNameStmt = $conn->prepare($checkNameQuery);
            $checkNameStmt->bind_param("si", $nombre, $id);
            $checkNameStmt->execute();

            if ($checkNameStmt->get_result()->num_rows > 0) {
                sendResponse(false, "Ya existe otra categoría con ese nombre");
            }

            // Actualizar la categoría
            $query = "UPDATE categorias SET nombre = ?, activo = ? WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("sii", $nombre, $activo, $id);

            if ($stmt->execute()) {
                sendResponse(true, "Categoría actualizada exitosamente");
            } else {
                sendResponse(false, "Error al actualizar la categoría");
            }

        } catch (Exception $e) {
            sendResponse(false, "Error al actualizar categoría: " . $e->getMessage());
        }
        break;

    case 'eliminarCategoria':
        $id = intval($datapost['id'] ?? 0);

        if ($id <= 0) {
            sendResponse(false, "ID de categoría requerido");
        }

        try {
            // Verificar que la categoría existe
            $checkQuery = "SELECT nombre FROM categorias WHERE id = ?";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("i", $id);
            $checkStmt->execute();
            $checkResult = $checkStmt->get_result();

            if ($checkResult->num_rows === 0) {
                sendResponse(false, "Categoría no encontrada");
            }

            $categoria = $checkResult->fetch_assoc();

            // Verificar si tiene productos asociados
            $productQuery = "SELECT COUNT(*) as count FROM productos WHERE categoria_id = ?";
            $productStmt = $conn->prepare($productQuery);
            $productStmt->bind_param("i", $id);
            $productStmt->execute();
            $productResult = $productStmt->get_result();
            $productCount = $productResult->fetch_assoc()['count'];

            if ($productCount > 0) {
                sendResponse(false, "No se puede eliminar la categoría porque tiene productos asociados. Primero debe reasignar o eliminar los productos.");
            }

            // Eliminar la categoría
            $deleteQuery = "DELETE FROM categorias WHERE id = ?";
            $deleteStmt = $conn->prepare($deleteQuery);
            $deleteStmt->bind_param("i", $id);

            if ($deleteStmt->execute()) {
                sendResponse(true, "Categoría eliminada exitosamente");
            } else {
                sendResponse(false, "Error al eliminar la categoría");
            }

        } catch (Exception $e) {
            sendResponse(false, "Error al eliminar categoría: " . $e->getMessage());
        }
        break;

    case 'ordenarCategorias':
        $categorias = $datapost['categorias'] ?? [];

        if (empty($categorias) || !is_array($categorias)) {
            sendResponse(false, "Lista de categorías requerida");
        }

        try {
            $conn->begin_transaction();

            foreach ($categorias as $index => $categoria) {
                $id = intval($categoria['id']);
                $orden = $index + 1;

                $updateQuery = "UPDATE categorias SET orden = ? WHERE id = ?";
                $updateStmt = $conn->prepare($updateQuery);
                $updateStmt->bind_param("ii", $orden, $id);
                $updateStmt->execute();
            }

            $conn->commit();
            sendResponse(true, "Orden de categorías actualizado exitosamente");

        } catch (Exception $e) {
            $conn->rollback();
            sendResponse(false, "Error al actualizar orden de categorías: " . $e->getMessage());
        }
        break;

    default:
        sendResponse(false, "Operación no válida para categorías");
        break;
}
?>