<?php
// Prevenir acceso directo
if (!defined('BASEPATH')) exit('No direct script access allowed');

switch ($tipo) {
    case 'getDashboardData':
        $session = $security->validateSession();
        if (!$session['valid']) {
            sendResponse(false, $session['message']);
        }

        try {
            $dashboardData = [];

            // Ventas del día
            $query = "SELECT COUNT(*) as total_ventas, COALESCE(SUM(total), 0) as total_ingresos
                     FROM ventas
                     WHERE DATE(fecha_venta) = CURDATE() AND estado = 'completada'";
            $result = $conn->query($query);
            $ventasHoy = $result->fetch_assoc();

            // Productos con bajo stock
            $query = "SELECT COUNT(*) as productos_bajo_stock
                     FROM productos
                     WHERE activo = 1 AND stock_actual <= stock_minimo";
            $result = $conn->query($query);
            $bajoStock = $result->fetch_assoc();

            // Total de productos
            $query = "SELECT COUNT(*) as total_productos
                     FROM productos
                     WHERE activo = 1";
            $result = $conn->query($query);
            $totalProductos = $result->fetch_assoc();

            // Total de clientes
            $query = "SELECT COUNT(*) as total_clientes
                     FROM clientes
                     WHERE activo = 1";
            $result = $conn->query($query);
            $totalClientes = $result->fetch_assoc();

            $dashboardData = [
                'ventas_hoy' => [
                    'cantidad' => intval($ventasHoy['total_ventas']),
                    'total' => floatval($ventasHoy['total_ingresos'])
                ],
                'productos_bajo_stock' => intval($bajoStock['productos_bajo_stock']),
                'total_productos' => intval($totalProductos['total_productos']),
                'total_clientes' => intval($totalClientes['total_clientes'])
            ];

            sendResponse(true, "Datos del dashboard obtenidos", $dashboardData);

        } catch (Exception $e) {
            sendResponse(false, "Error al obtener datos del dashboard: " . $e->getMessage());
        }
        break;

    case 'getVentasHoy':
        $session = $security->validateSession();
        if (!$session['valid']) {
            sendResponse(false, $session['message']);
        }

        try {
            $query = "SELECT v.*, c.nombre as cliente_nombre, u.nombre as usuario_nombre
                     FROM ventas v
                     LEFT JOIN clientes c ON v.cliente_id = c.id
                     LEFT JOIN usuarios u ON v.usuario_id = u.id
                     WHERE DATE(v.fecha_venta) = CURDATE()
                     ORDER BY v.fecha_venta DESC
                     LIMIT 10";

            $result = $conn->query($query);
            $ventas = [];

            while ($row = $result->fetch_assoc()) {
                $ventas[] = [
                    'id' => $row['id'],
                    'folio' => $row['folio'],
                    'cliente_nombre' => $row['cliente_nombre'] ?: 'Cliente General',
                    'usuario_nombre' => $row['usuario_nombre'],
                    'total' => floatval($row['total']),
                    'fecha_venta' => $row['fecha_venta'],
                    'estado' => $row['estado']
                ];
            }

            sendResponse(true, "Ventas de hoy obtenidas", $ventas);

        } catch (Exception $e) {
            sendResponse(false, "Error al obtener ventas de hoy: " . $e->getMessage());
        }
        break;

    default:
        sendResponse(false, "Operación de dashboard no válida");
        break;
}
?>