<?php
// VERSION SIN AUTENTICACION PARA PRUEBAS
// ADVERTENCIA: NO USAR EN PRODUCCIÓN

if (!defined('BASEPATH')) exit('No direct script access allowed');

switch ($tipo) {
    case 'getProductos':
        try {
            $query = "SELECT p.*, c.nombre as categoria_nombre, pr.nombre as proveedor_nombre
                     FROM productos p
                     LEFT JOIN categorias c ON p.categoria_id = c.id
                     LEFT JOIN proveedores pr ON p.proveedor_id = pr.id
                     WHERE p.activo = 1
                     ORDER BY p.nombre";

            $result = $conn->query($query);
            $productos = [];

            while ($row = $result->fetch_assoc()) {
                $productos[] = [
                    'id' => $row['id'],
                    'codigo_barras' => $row['codigo_barras'],
                    'nombre' => $row['nombre'],
                    'descripcion' => $row['descripcion'],
                    'categoria_id' => $row['categoria_id'],
                    'categoria_nombre' => $row['categoria_nombre'],
                    'proveedor_id' => $row['proveedor_id'],
                    'proveedor_nombre' => $row['proveedor_nombre'],
                    'precio_compra' => floatval($row['precio_compra']),
                    'precio_venta' => floatval($row['precio_venta']),
                    'stock_actual' => intval($row['stock_actual']),
                    'stock_minimo' => intval($row['stock_minimo']),
                    'stock_maximo' => intval($row['stock_maximo']),
                    'imagen' => $row['imagen']
                ];
            }

            // Agregar algunos productos de ejemplo si no hay ninguno
            if (count($productos) == 0) {
                $productos = [
                    [
                        'id' => 1,
                        'codigo_barras' => '7501000123456',
                        'nombre' => 'Coca Cola 600ml',
                        'descripcion' => 'Refresco de cola',
                        'categoria_id' => 2,
                        'categoria_nombre' => 'Bebidas',
                        'precio_venta' => 15.00,
                        'stock_actual' => 24,
                        'stock_minimo' => 10,
                        'imagen' => null
                    ],
                    [
                        'id' => 2,
                        'codigo_barras' => '7501000123457',
                        'nombre' => 'Sabritas 45g',
                        'descripcion' => 'Papas fritas',
                        'categoria_id' => 1,
                        'categoria_nombre' => 'Abarrotes',
                        'precio_venta' => 18.00,
                        'stock_actual' => 36,
                        'stock_minimo' => 15,
                        'imagen' => null
                    ],
                    [
                        'id' => 3,
                        'codigo_barras' => '7501000123458',
                        'nombre' => 'Leche Alpura 1L',
                        'descripcion' => 'Leche entera',
                        'categoria_id' => 3,
                        'categoria_nombre' => 'Lácteos',
                        'precio_venta' => 25.50,
                        'stock_actual' => 12,
                        'stock_minimo' => 8,
                        'imagen' => null
                    ]
                ];
            }

            sendResponse(true, "Productos obtenidos", $productos);

        } catch (Exception $e) {
            sendResponse(false, "Error al obtener productos: " . $e->getMessage());
        }
        break;

    default:
        sendResponse(false, "Operación de productos no válida");
        break;
}
?>