<?php
// Prevenir acceso directo
if (!defined('BASEPATH')) exit('No direct script access allowed');

switch ($tipo) {
    // Obtener todos los proveedores
    case 'getProveedores':
        try {
            $query = "SELECT * FROM proveedores ORDER BY nombre ASC";
            $result = $conn->query($query);

            if (!$result) {
                sendResponse(false, "Error en consulta: " . $conn->error);
                break;
            }

            $proveedores = [];
            while ($row = $result->fetch_assoc()) {
                $row['id'] = (int)$row['id'];
                $row['activo'] = (int)$row['activo'];
                $proveedores[] = $row;
            }

            sendResponse(true, "Proveedores obtenidos correctamente", $proveedores);
        } catch (Exception $e) {
            error_log("Error al obtener proveedores: " . $e->getMessage());
            sendResponse(false, "Error al obtener proveedores");
        }
        break;

    // Obtener un proveedor por ID
    case 'getProveedor':
        try {
            $id = isset($datapost['id']) ? intval($datapost['id']) : 0;

            if ($id <= 0) {
                sendResponse(false, "ID de proveedor no válido");
                break;
            }

            $query = "SELECT * FROM proveedores WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $result = $stmt->get_result();
            $proveedor = $result->fetch_assoc();

            if ($proveedor) {
                $proveedor['id'] = (int)$proveedor['id'];
                $proveedor['activo'] = (int)$proveedor['activo'];
                sendResponse(true, "Proveedor obtenido correctamente", $proveedor);
            } else {
                sendResponse(false, "Proveedor no encontrado");
            }
        } catch (Exception $e) {
            error_log("Error al obtener proveedor: " . $e->getMessage());
            sendResponse(false, "Error al obtener proveedor");
        }
        break;

    // Crear proveedor
    case 'crearProveedor':
        try {
            $nombre = isset($datapost['nombre']) ? trim($datapost['nombre']) : '';
            $contacto = isset($datapost['contacto']) ? trim($datapost['contacto']) : '';
            $telefono = isset($datapost['telefono']) ? trim($datapost['telefono']) : '';
            $email = isset($datapost['email']) ? trim($datapost['email']) : '';
            $direccion = isset($datapost['direccion']) ? trim($datapost['direccion']) : '';
            $rfc = isset($datapost['rfc']) ? trim($datapost['rfc']) : '';
            $activo = isset($datapost['activo']) ? intval($datapost['activo']) : 1;

            // Validaciones
            if (empty($nombre)) {
                sendResponse(false, "El nombre del proveedor es requerido");
                break;
            }

            // Verificar si ya existe un proveedor con el mismo nombre
            $checkQuery = "SELECT id FROM proveedores WHERE nombre = ?";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("s", $nombre);
            $checkStmt->execute();
            $checkResult = $checkStmt->get_result();

            if ($checkResult->num_rows > 0) {
                sendResponse(false, "Ya existe un proveedor con ese nombre");
                break;
            }

            $query = "INSERT INTO proveedores (nombre, contacto, telefono, email, direccion, rfc, activo)
                      VALUES (?, ?, ?, ?, ?, ?, ?)";

            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssssssi", $nombre, $contacto, $telefono, $email, $direccion, $rfc, $activo);

            if ($stmt->execute()) {
                sendResponse(true, "Proveedor creado correctamente", ["id" => $conn->insert_id]);
            } else {
                error_log("Error SQL al crear proveedor: " . $stmt->error);
                sendResponse(false, "Error al crear proveedor: " . $stmt->error);
            }
        } catch (Exception $e) {
            error_log("Error al crear proveedor: " . $e->getMessage());
            sendResponse(false, "Error al crear proveedor");
        }
        break;

    // Actualizar proveedor
    case 'actualizarProveedor':
        try {
            $id = isset($datapost['id']) ? intval($datapost['id']) : 0;
            $nombre = isset($datapost['nombre']) ? trim($datapost['nombre']) : '';
            $contacto = isset($datapost['contacto']) ? trim($datapost['contacto']) : '';
            $telefono = isset($datapost['telefono']) ? trim($datapost['telefono']) : '';
            $email = isset($datapost['email']) ? trim($datapost['email']) : '';
            $direccion = isset($datapost['direccion']) ? trim($datapost['direccion']) : '';
            $rfc = isset($datapost['rfc']) ? trim($datapost['rfc']) : '';
            $activo = isset($datapost['activo']) ? intval($datapost['activo']) : 1;

            if ($id <= 0) {
                sendResponse(false, "ID de proveedor no válido");
                break;
            }

            if (empty($nombre)) {
                sendResponse(false, "El nombre del proveedor es requerido");
                break;
            }

            // Verificar si existe otro proveedor con el mismo nombre
            $checkQuery = "SELECT id FROM proveedores WHERE nombre = ? AND id != ?";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("si", $nombre, $id);
            $checkStmt->execute();
            $checkResult = $checkStmt->get_result();

            if ($checkResult->num_rows > 0) {
                sendResponse(false, "Ya existe otro proveedor con ese nombre");
                break;
            }

            $query = "UPDATE proveedores SET
                      nombre = ?,
                      contacto = ?,
                      telefono = ?,
                      email = ?,
                      direccion = ?,
                      rfc = ?,
                      activo = ?
                      WHERE id = ?";

            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssssssii", $nombre, $contacto, $telefono, $email, $direccion, $rfc, $activo, $id);

            if ($stmt->execute()) {
                sendResponse(true, "Proveedor actualizado correctamente");
            } else {
                error_log("Error SQL al actualizar proveedor: " . $stmt->error);
                sendResponse(false, "Error al actualizar proveedor: " . $stmt->error);
            }
        } catch (Exception $e) {
            error_log("Error al actualizar proveedor: " . $e->getMessage());
            sendResponse(false, "Error al actualizar proveedor");
        }
        break;

    // Eliminar proveedor (soft delete)
    case 'eliminarProveedor':
        try {
            $id = isset($datapost['id']) ? intval($datapost['id']) : 0;

            if ($id <= 0) {
                sendResponse(false, "ID de proveedor no válido");
                break;
            }

            // Verificar si tiene órdenes de compra asociadas
            $checkQuery = "SELECT COUNT(*) as total FROM ordenes_compra WHERE proveedor_id = ?";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("i", $id);
            $checkStmt->execute();
            $checkResult = $checkStmt->get_result();
            $row = $checkResult->fetch_assoc();

            if ($row['total'] > 0) {
                // Soft delete si tiene órdenes asociadas
                $query = "UPDATE proveedores SET activo = 0 WHERE id = ?";
            } else {
                // Hard delete si no tiene órdenes
                $query = "DELETE FROM proveedores WHERE id = ?";
            }

            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $id);

            if ($stmt->execute()) {
                sendResponse(true, "Proveedor eliminado correctamente");
            } else {
                sendResponse(false, "Error al eliminar proveedor");
            }
        } catch (Exception $e) {
            error_log("Error al eliminar proveedor: " . $e->getMessage());
            sendResponse(false, "Error al eliminar proveedor");
        }
        break;

    // Buscar proveedores
    case 'buscarProveedores':
        try {
            $query_search = isset($datapost['query']) ? trim($datapost['query']) : '';

            if (empty($query_search)) {
                sendResponse(false, "Término de búsqueda requerido");
                break;
            }

            $searchTerm = "%{$query_search}%";
            $query = "SELECT * FROM proveedores
                      WHERE (nombre LIKE ? OR contacto LIKE ? OR telefono LIKE ? OR email LIKE ?)
                      AND activo = 1
                      ORDER BY nombre ASC
                      LIMIT 20";

            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssss", $searchTerm, $searchTerm, $searchTerm, $searchTerm);
            $stmt->execute();
            $result = $stmt->get_result();

            $proveedores = [];
            while ($row = $result->fetch_assoc()) {
                $row['id'] = (int)$row['id'];
                $row['activo'] = (int)$row['activo'];
                $proveedores[] = $row;
            }

            sendResponse(true, "Búsqueda completada", $proveedores);
        } catch (Exception $e) {
            error_log("Error en búsqueda de proveedores: " . $e->getMessage());
            sendResponse(false, "Error en la búsqueda");
        }
        break;

    // Obtener productos de un proveedor
    case 'getProductosProveedor':
        try {
            $proveedor_id = isset($datapost['proveedor_id']) ? intval($datapost['proveedor_id']) : 0;

            if ($proveedor_id <= 0) {
                sendResponse(false, "ID de proveedor no válido");
                break;
            }

            $query = "SELECT * FROM productos
                      WHERE proveedor_id = ? AND activo = 1
                      ORDER BY nombre ASC";

            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $proveedor_id);
            $stmt->execute();
            $result = $stmt->get_result();

            $productos = [];
            while ($row = $result->fetch_assoc()) {
                $productos[] = $row;
            }

            sendResponse(true, "Productos del proveedor obtenidos", $productos);
        } catch (Exception $e) {
            error_log("Error al obtener productos del proveedor: " . $e->getMessage());
            sendResponse(false, "Error al obtener productos");
        }
        break;

    default:
        sendResponse(false, "Operación de proveedores no válida: " . $tipo);
        break;
}
