<?php
// Prevenir acceso directo
if (!defined('BASEPATH')) exit('No direct script access allowed');

switch ($tipo) {
    case 'getRangosFlete':
        try {
            $query = "SELECT r.id, r.distancia_desde, r.distancia_hasta, r.vehiculo_id, r.costo, r.activo,
                            r.fecha_creacion, r.fecha_actualizacion,
                            v.nombre as vehiculo_nombre, v.placa as vehiculo_placa
                     FROM rangos_flete r
                     LEFT JOIN vehiculos v ON r.vehiculo_id = v.id
                     where r.activo = 1
                     ORDER BY r.distancia_desde ASC";

            $result = $conn->query($query);
            if (!$result) {
                sendResponse(false, "Error en consulta: " . $conn->error);
                break;
            }

            $rangos = [];
            while ($row = $result->fetch_assoc()) {
                $row['activo'] = (bool)$row['activo'];
                $row['distancia_desde'] = (float)$row['distancia_desde'];
                $row['distancia_hasta'] = (float)$row['distancia_hasta'];
                $row['costo'] = (float)$row['costo'];
                $row['vehiculo_id'] = $row['vehiculo_id'] ? (int)$row['vehiculo_id'] : null;
                $rangos[] = $row;
            }

            sendResponse(true, "Rangos de flete obtenidos correctamente", $rangos);
        } catch (Exception $e) {
            error_log("Error al obtener rangos de flete: " . $e->getMessage());
            sendResponse(false, "Error al obtener rangos de flete");
        }
        break;

    case 'crearRangoFlete':
        try {
            $distancia_desde = isset($datapost['distancia_desde']) ? floatval($datapost['distancia_desde']) : 0;
            $distancia_hasta = isset($datapost['distancia_hasta']) ? floatval($datapost['distancia_hasta']) : 0;
            $vehiculo_id = isset($datapost['vehiculo_id']) && !empty($datapost['vehiculo_id']) ? intval($datapost['vehiculo_id']) : null;
            $costo = isset($datapost['costo']) ? floatval($datapost['costo']) : 0;
            $activo = isset($datapost['activo']) ? intval($datapost['activo']) : 1;

            if ($distancia_hasta <= 0 || $costo <= 0) {
                sendResponse(false, "Distancia hasta y costo son requeridos");
                break;
            }

            if ($distancia_desde >= $distancia_hasta) {
                sendResponse(false, "La distancia hasta debe ser mayor a la distancia desde");
                break;
            }

            // Verificar que el vehículo existe si se especificó
            if ($vehiculo_id !== null) {
                $vehiculoQuery = "SELECT id FROM vehiculos WHERE id = ? AND activo = 1";
                $vehiculoStmt = $conn->prepare($vehiculoQuery);
                $vehiculoStmt->bind_param("i", $vehiculo_id);
                $vehiculoStmt->execute();
                $vehiculoResult = $vehiculoStmt->get_result();

                if ($vehiculoResult->num_rows === 0) {
                    sendResponse(false, "El vehículo especificado no existe o está inactivo");
                    break;
                }
            }

            $query = "INSERT INTO rangos_flete (distancia_desde, distancia_hasta, vehiculo_id, costo, activo)
                     VALUES (?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ddidi", $distancia_desde, $distancia_hasta, $vehiculo_id, $costo, $activo);

            if ($stmt->execute()) {
                sendResponse(true, "Rango de flete creado correctamente", ['id' => $conn->insert_id]);
            } else {
                error_log("Error SQL al crear rango: " . $stmt->error);
                sendResponse(false, "Error al crear rango de flete: " . $stmt->error);
            }
        } catch (Exception $e) {
            error_log("Error al crear rango de flete: " . $e->getMessage());
            sendResponse(false, "Error al crear rango de flete");
        }
        break;

    case 'actualizarRangoFlete':
        try {
            $id = isset($datapost['id']) ? intval($datapost['id']) : 0;
            $distancia_desde = isset($datapost['distancia_desde']) ? floatval($datapost['distancia_desde']) : 0;
            $distancia_hasta = isset($datapost['distancia_hasta']) ? floatval($datapost['distancia_hasta']) : 0;
            $vehiculo_id = isset($datapost['vehiculo_id']) && !empty($datapost['vehiculo_id']) ? intval($datapost['vehiculo_id']) : null;
            $costo = isset($datapost['costo']) ? floatval($datapost['costo']) : 0;
            $activo = isset($datapost['activo']) ? intval($datapost['activo']) : 1;

            if ($id <= 0 || $distancia_hasta <= 0 || $costo <= 0) {
                sendResponse(false, "ID, distancia hasta y costo son requeridos");
                break;
            }

            if ($distancia_desde >= $distancia_hasta) {
                sendResponse(false, "La distancia hasta debe ser mayor a la distancia desde");
                break;
            }

            // Verificar que el vehículo existe si se especificó
            if ($vehiculo_id !== null) {
                $vehiculoQuery = "SELECT id FROM vehiculos WHERE id = ? AND activo = 1";
                $vehiculoStmt = $conn->prepare($vehiculoQuery);
                $vehiculoStmt->bind_param("i", $vehiculo_id);
                $vehiculoStmt->execute();
                $vehiculoResult = $vehiculoStmt->get_result();

                if ($vehiculoResult->num_rows === 0) {
                    sendResponse(false, "El vehículo especificado no existe o está inactivo");
                    break;
                }
            }

            $query = "UPDATE rangos_flete SET distancia_desde = ?, distancia_hasta = ?, vehiculo_id = ?,
                     costo = ?, activo = ?, fecha_actualizacion = CURRENT_TIMESTAMP
                     WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ddidii", $distancia_desde, $distancia_hasta, $vehiculo_id, $costo, $activo, $id);

            if ($stmt->execute()) {
                sendResponse(true, "Rango de flete actualizado correctamente");
            } else {
                error_log("Error SQL al actualizar rango: " . $stmt->error);
                sendResponse(false, "Error al actualizar rango de flete: " . $stmt->error);
            }
        } catch (Exception $e) {
            error_log("Error al actualizar rango de flete: " . $e->getMessage());
            sendResponse(false, "Error al actualizar rango de flete");
        }
        break;

    case 'eliminarRangoFlete':
        try {
            $id = isset($datapost['id']) ? intval($datapost['id']) : 0;

            if ($id <= 0) {
                sendResponse(false, "ID del rango requerido");
                break;
            }

            // Soft delete - marcar como inactivo
            $query = "UPDATE rangos_flete SET activo = 0 WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $id);

            if ($stmt->execute()) {
                sendResponse(true, "Rango de flete eliminado correctamente");
            } else {
                sendResponse(false, "Error al eliminar rango de flete");
            }
        } catch (Exception $e) {
            error_log("Error al eliminar rango de flete: " . $e->getMessage());
            sendResponse(false, "Error al eliminar rango de flete");
        }
        break;


    default:
        sendResponse(false, "Operación no válida para rangos de flete");
        break;
}
