<?php
// VERSION SIN AUTENTICACION PARA PRUEBAS
// ADVERTENCIA: NO USAR EN PRODUCCIÓN

if (!defined('BASEPATH')) exit('No direct script access allowed');

switch ($tipo) {
    case 'getUsuarios':
        try {
            $query = "SELECT u.id, u.usuario, u.nombre, u.email, u.telefono, u.activo,
                            u.fecha_creacion, u.ultimo_acceso, u.rol_id, r.nombre as rol_nombre,
                            r.necesita_almacen
                     FROM usuarios u
                     LEFT JOIN roles r ON u.rol_id = r.id
                     ORDER BY u.nombre";

            $result = $conn->query($query);
            $usuarios = [];

            while ($row = $result->fetch_assoc()) {
                // Obtener almacenes asignados al usuario
                $usuario_id = $row['id'];
                $almacenes_query = "SELECT a.id, a.nombre, a.codigo
                                   FROM usuario_almacenes ua
                                   JOIN almacenes a ON ua.almacen_id = a.id
                                   WHERE ua.usuario_id = ? AND a.activo = 1";
                $stmt_almacenes = $conn->prepare($almacenes_query);
                $stmt_almacenes->bind_param("i", $usuario_id);
                $stmt_almacenes->execute();
                $result_almacenes = $stmt_almacenes->get_result();

                $almacenes = [];
                while ($almacen = $result_almacenes->fetch_assoc()) {
                    $almacenes[] = [
                        'id' => intval($almacen['id']),
                        'nombre' => $almacen['nombre'],
                        'codigo' => $almacen['codigo']
                    ];
                }

                $row['almacenes'] = $almacenes;
                $row['almacenes_ids'] = array_column($almacenes, 'id');
                $row['necesita_almacen'] = (bool)$row['necesita_almacen'];
                $usuarios[] = $row;
            }

            // Si no hay usuarios, agregar algunos de ejemplo
            if (count($usuarios) == 0) {
                $usuarios = [
                    [
                        'id' => 1,
                        'usuario' => 'admin',
                        'nombre' => 'Administrador',
                        'email' => 'admin@abarrotes.com',
                        'telefono' => '555-123-4567',
                        'activo' => 1,
                        'fecha_creacion' => '2024-01-01 10:00:00',
                        'ultimo_acceso' => '2024-01-21 15:30:00',
                        'rol_nombre' => 'Administrador'
                    ],
                    [
                        'id' => 2,
                        'usuario' => 'cajero',
                        'nombre' => 'Juan Pérez',
                        'email' => 'cajero@abarrotes.com',
                        'telefono' => '555-234-5678',
                        'activo' => 1,
                        'fecha_creacion' => '2024-01-05 09:00:00',
                        'ultimo_acceso' => '2024-01-21 14:20:00',
                        'rol_nombre' => 'Cajero'
                    ],
                    [
                        'id' => 3,
                        'usuario' => 'gerente',
                        'nombre' => 'María García',
                        'email' => 'gerente@abarrotes.com',
                        'telefono' => '555-345-6789',
                        'activo' => 1,
                        'fecha_creacion' => '2024-01-03 11:00:00',
                        'ultimo_acceso' => '2024-01-21 10:15:00',
                        'rol_nombre' => 'Gerente'
                    ],
                    [
                        'id' => 4,
                        'usuario' => 'almacen',
                        'nombre' => 'Carlos López',
                        'email' => 'almacen@abarrotes.com',
                        'telefono' => '555-456-7890',
                        'activo' => 1,
                        'fecha_creacion' => '2024-01-10 08:30:00',
                        'ultimo_acceso' => null,
                        'rol_nombre' => 'Almacenista'
                    ],
                    [
                        'id' => 5,
                        'usuario' => 'temporal',
                        'nombre' => 'Ana Martínez',
                        'email' => 'temporal@abarrotes.com',
                        'telefono' => null,
                        'activo' => 0,
                        'fecha_creacion' => '2024-01-15 14:00:00',
                        'ultimo_acceso' => '2024-01-18 16:00:00',
                        'rol_nombre' => 'Cajero'
                    ]
                ];
            }

            sendResponse(true, "Usuarios obtenidos", $usuarios);

        } catch (Exception $e) {
            sendResponse(false, "Error al obtener usuarios: " . $e->getMessage());
        }
        break;

    case 'crearUsuario':
        $usuario = $security->validateInput($datapost['usuario'] ?? '');
        $nombre = $security->validateInput($datapost['nombre'] ?? '');
        $email = $security->validateInput($datapost['email'] ?? '');
        $password = $datapost['password'] ?? '';
        $rol_id = intval($datapost['rol_id'] ?? 0);
        $telefono = $security->validateInput($datapost['telefono'] ?? '');
        $almacenes_ids = isset($datapost['almacenes_ids']) ? $datapost['almacenes_ids'] : [];

        if (empty($usuario) || empty($nombre) || empty($email) || empty($password) || $rol_id == 0) {
            sendResponse(false, "Todos los campos son requeridos");
        }

        if (!validarEmail($email)) {
            sendResponse(false, "Email no válido");
        }

        try {
            // Verificar si el usuario ya existe
            $checkQuery = "SELECT id FROM usuarios WHERE usuario = ? OR email = ?";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("ss", $usuario, $email);
            $checkStmt->execute();

            if ($checkStmt->get_result()->num_rows > 0) {
                sendResponse(false, "El usuario o email ya existe");
            }

            // Verificar si el rol requiere almacén
            $rol_query = "SELECT necesita_almacen FROM roles WHERE id = ?";
            $stmt_rol = $conn->prepare($rol_query);
            $stmt_rol->bind_param("i", $rol_id);
            $stmt_rol->execute();
            $rol_result = $stmt_rol->get_result();
            $rol_data = $rol_result->fetch_assoc();

            if ($rol_data && $rol_data['necesita_almacen'] && empty($almacenes_ids)) {
                sendResponse(false, "Este rol requiere al menos un almacén asignado");
            }

            // Iniciar transacción
            $conn->begin_transaction();

            // Crear usuario
            $hashedPassword = $myencrypt->hashPassword($password);

            $query = "INSERT INTO usuarios (usuario, nombre, email, password, rol_id, telefono, activo, fecha_creacion)
                     VALUES (?, ?, ?, ?, ?, ?, 1, NOW())";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssssis", $usuario, $nombre, $email, $hashedPassword, $rol_id, $telefono);

            if (!$stmt->execute()) {
                $conn->rollback();
                sendResponse(false, "Error al crear usuario");
            }

            $user_id = $conn->insert_id;

            // Asignar almacenes si se proporcionaron
            if (!empty($almacenes_ids) && is_array($almacenes_ids)) {
                $stmt_almacen = $conn->prepare("INSERT INTO usuario_almacenes (usuario_id, almacen_id) VALUES (?, ?)");

                foreach ($almacenes_ids as $almacen_id) {
                    $almacen_id = intval($almacen_id);
                    if ($almacen_id > 0) {
                        $stmt_almacen->bind_param("ii", $user_id, $almacen_id);
                        if (!$stmt_almacen->execute()) {
                            $conn->rollback();
                            sendResponse(false, "Error al asignar almacenes");
                        }
                    }
                }
            }

            $conn->commit();
            sendResponse(true, "Usuario creado exitosamente", ['user_id' => $user_id]);

        } catch (Exception $e) {
            if ($conn->connect_errno === 0) {
                $conn->rollback();
            }
            sendResponse(false, "Error al crear usuario: " . $e->getMessage());
        }
        break;

    case 'actualizarUsuario':
        $user_id = intval($datapost['user_id'] ?? 0);
        $nombre = $security->validateInput($datapost['nombre'] ?? '');
        $email = $security->validateInput($datapost['email'] ?? '');
        $rol_id = intval($datapost['rol_id'] ?? 0);
        $telefono = $security->validateInput($datapost['telefono'] ?? '');
        $activo = intval($datapost['activo'] ?? 1);
        $password = $datapost['password'] ?? '';
        $almacenes_ids = isset($datapost['almacenes_ids']) ? $datapost['almacenes_ids'] : null;

        if ($user_id == 0 || empty($nombre) || empty($email) || $rol_id == 0) {
            sendResponse(false, "Datos requeridos faltantes");
        }

        if (!validarEmail($email)) {
            sendResponse(false, "Email no válido");
        }

        try {
            // Verificar si el email ya está en uso por otro usuario
            $checkQuery = "SELECT id FROM usuarios WHERE email = ? AND id != ?";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("si", $email, $user_id);
            $checkStmt->execute();

            if ($checkStmt->get_result()->num_rows > 0) {
                sendResponse(false, "El email ya está en uso por otro usuario");
            }

            // Verificar si el rol requiere almacén
            $rol_query = "SELECT necesita_almacen FROM roles WHERE id = ?";
            $stmt_rol = $conn->prepare($rol_query);
            $stmt_rol->bind_param("i", $rol_id);
            $stmt_rol->execute();
            $rol_result = $stmt_rol->get_result();
            $rol_data = $rol_result->fetch_assoc();

            if ($rol_data && $rol_data['necesita_almacen'] && isset($almacenes_ids) && empty($almacenes_ids)) {
                sendResponse(false, "Este rol requiere al menos un almacén asignado");
            }

            // Iniciar transacción
            $conn->begin_transaction();

            // Si se proporciona password, actualizar con password
            if (!empty($password)) {
                $hashedPassword = $myencrypt->hashPassword($password);
                $query = "UPDATE usuarios SET nombre = ?, email = ?, rol_id = ?, telefono = ?, activo = ?, password = ?
                         WHERE id = ?";
                $stmt = $conn->prepare($query);
                $stmt->bind_param("ssisssi", $nombre, $email, $rol_id, $telefono, $activo, $hashedPassword, $user_id);
            } else {
                // Actualizar sin cambiar el password
                $query = "UPDATE usuarios SET nombre = ?, email = ?, rol_id = ?, telefono = ?, activo = ?
                         WHERE id = ?";
                $stmt = $conn->prepare($query);
                $stmt->bind_param("ssissi", $nombre, $email, $rol_id, $telefono, $activo, $user_id);
            }

            if (!$stmt->execute()) {
                $conn->rollback();
                sendResponse(false, "Error al actualizar usuario");
            }

            // Actualizar almacenes si se proporcionaron
            if (isset($almacenes_ids)) {
                // Eliminar asignaciones actuales
                $delete_query = "DELETE FROM usuario_almacenes WHERE usuario_id = ?";
                $stmt_delete = $conn->prepare($delete_query);
                $stmt_delete->bind_param("i", $user_id);

                if (!$stmt_delete->execute()) {
                    $conn->rollback();
                    sendResponse(false, "Error al actualizar asignaciones de almacenes");
                }

                // Asignar nuevos almacenes
                if (!empty($almacenes_ids) && is_array($almacenes_ids)) {
                    $stmt_almacen = $conn->prepare("INSERT INTO usuario_almacenes (usuario_id, almacen_id) VALUES (?, ?)");

                    foreach ($almacenes_ids as $almacen_id) {
                        $almacen_id = intval($almacen_id);
                        if ($almacen_id > 0) {
                            $stmt_almacen->bind_param("ii", $user_id, $almacen_id);
                            if (!$stmt_almacen->execute()) {
                                $conn->rollback();
                                sendResponse(false, "Error al asignar almacenes");
                            }
                        }
                    }
                }
            }

            $conn->commit();
            sendResponse(true, "Usuario actualizado exitosamente");

        } catch (Exception $e) {
            if ($conn->connect_errno === 0) {
                $conn->rollback();
            }
            sendResponse(false, "Error al actualizar usuario: " . $e->getMessage());
        }
        break;

    case 'eliminarUsuario':
        $user_id = intval($datapost['user_id'] ?? 0);

        if ($user_id == 0) {
            sendResponse(false, "ID de usuario requerido");
        }

        try {
            // Desactivar usuario en lugar de eliminarlo (soft delete)
            $query = "UPDATE usuarios SET activo = 0 WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $user_id);

            if ($stmt->execute()) {
                sendResponse(true, "Usuario eliminado exitosamente");
            } else {
                sendResponse(false, "Error al eliminar usuario");
            }
        } catch (Exception $e) {
            sendResponse(false, "Error al eliminar usuario: " . $e->getMessage());
        }
        break;

    default:
        sendResponse(false, "Operación de usuarios no válida");
        break;
}
?>