<?php
// Prevenir acceso directo
if (!defined('BASEPATH')) exit('No direct script access allowed');

switch ($tipo) {
    case 'getVehiculos':
        try {
            $query = "SELECT id, nombre, placa, activo, fecha_creacion, fecha_actualizacion
                     FROM vehiculos
                     ORDER BY nombre ASC";

            $result = $conn->query($query);
            if (!$result) {
                sendResponse(false, "Error en consulta: " . $conn->error);
                break;
            }

            $vehiculos = [];
            while ($row = $result->fetch_assoc()) {
                $row['activo'] = (bool)$row['activo'];
                $vehiculos[] = $row;
            }

            sendResponse(true, "Vehículos obtenidos correctamente", $vehiculos);
        } catch (Exception $e) {
            error_log("Error al obtener vehículos: " . $e->getMessage());
            sendResponse(false, "Error al obtener vehículos");
        }
        break;

    case 'crearVehiculo':
        try {
            $nombre = isset($datapost['nombre']) ? trim($datapost['nombre']) : '';
            $placa = isset($datapost['placa']) ? strtoupper(trim($datapost['placa'])) : '';
            $activo = isset($datapost['activo']) ? intval($datapost['activo']) : 1;

            if (empty($nombre) || empty($placa)) {
                sendResponse(false, "Nombre y placa son requeridos");
                break;
            }

            // Verificar que la placa no exista
            $checkQuery = "SELECT id FROM vehiculos WHERE placa = ?";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("s", $placa);
            $checkStmt->execute();
            $checkResult = $checkStmt->get_result();

            if ($checkResult->num_rows > 0) {
                sendResponse(false, "Ya existe un vehículo con esa placa");
                break;
            }

            $query = "INSERT INTO vehiculos (nombre, placa, activo) VALUES (?, ?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssi", $nombre, $placa, $activo);

            if ($stmt->execute()) {
                sendResponse(true, "Vehículo creado correctamente", ['id' => $conn->insert_id]);
            } else {
                sendResponse(false, "Error al crear vehículo");
            }
        } catch (Exception $e) {
            error_log("Error al crear vehículo: " . $e->getMessage());
            sendResponse(false, "Error al crear vehículo");
        }
        break;

    case 'actualizarVehiculo':
        try {
            $id = isset($datapost['id']) ? intval($datapost['id']) : 0;
            $nombre = isset($datapost['nombre']) ? trim($datapost['nombre']) : '';
            $placa = isset($datapost['placa']) ? strtoupper(trim($datapost['placa'])) : '';
            $activo = isset($datapost['activo']) ? intval($datapost['activo']) : 1;

            if ($id <= 0 || empty($nombre) || empty($placa)) {
                sendResponse(false, "ID, nombre y placa son requeridos");
                break;
            }

            // Verificar que la placa no exista en otro vehículo
            $checkQuery = "SELECT id FROM vehiculos WHERE placa = ? AND id != ?";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bind_param("si", $placa, $id);
            $checkStmt->execute();
            $checkResult = $checkStmt->get_result();

            if ($checkResult->num_rows > 0) {
                sendResponse(false, "Ya existe otro vehículo con esa placa");
                break;
            }

            $query = "UPDATE vehiculos SET nombre = ?, placa = ?, activo = ?,
                     fecha_actualizacion = CURRENT_TIMESTAMP WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssii", $nombre, $placa, $activo, $id);

            if ($stmt->execute()) {
                sendResponse(true, "Vehículo actualizado correctamente");
            } else {
                sendResponse(false, "Error al actualizar vehículo");
            }
        } catch (Exception $e) {
            error_log("Error al actualizar vehículo: " . $e->getMessage());
            sendResponse(false, "Error al actualizar vehículo");
        }
        break;

    case 'eliminarVehiculo':
        try {
            $id = isset($datapost['id']) ? intval($datapost['id']) : 0;

            if ($id <= 0) {
                sendResponse(false, "ID del vehículo requerido");
                break;
            }

            // Soft delete - marcar como inactivo
            $query = "UPDATE vehiculos SET activo = 0 WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $id);

            if ($stmt->execute()) {
                sendResponse(true, "Vehículo eliminado correctamente");
            } else {
                sendResponse(false, "Error al eliminar vehículo");
            }
        } catch (Exception $e) {
            error_log("Error al eliminar vehículo: " . $e->getMessage());
            sendResponse(false, "Error al eliminar vehículo");
        }
        break;

    default:
        sendResponse(false, "Operación no válida para vehículos");
        break;
}
?>