<?php
// Definir BASEPATH para seguridad
if (!defined('BASEPATH')) define('BASEPATH', true);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json; charset=UTF-8");

// Para solicitudes OPTIONS (preflight CORS)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Incluir archivos de conexión y funciones
require("./connect.php");
include('../../vendor/funciones.php');
include('../../vendor/DBA.php');
include('../../vendor/EncryptClass.php');
include('../../vendor/Security.php');

// Inicializar clases principales
$security = new Security();
$myencrypt = new EncryptClass();
$tokenID = getCode();

// Obtener los datos de la solicitud
$input = file_get_contents('php://input');
$datapost = json_decode($input, true);

// Obtener el tipo de operación
$tipo = isset($_POST['tipo']) ? $_POST['tipo'] : (isset($_GET['tipo']) ? $_GET['tipo'] : (isset($datapost['tipo']) ? $datapost['tipo'] : ''));

function getSystemInfo()
{
    return [
        'version' => '1.2.0',
        'api_version' => '1.0',
        'date' => date('Y-m-d H:i:s'),
        'php_version' => PHP_VERSION,
        'server' => $_SERVER['SERVER_SOFTWARE'],
        'system' => 'POS Abarrotes API'
    ];
}

// Función para enviar respuesta JSON
function sendResponse($success, $message = '', $data = null)
{
    echo json_encode([
        "success" => $success,
        "message" => $message,
        "data" => $data
    ]);
    exit;
}

// Si no hay tipo de operación, mostrar error
if (empty($tipo)) {
    // Si no hay tipo pero es un GET sin parámetros, mostrar info de la API
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && empty($_GET)) {
        echo json_encode([
            "success" => true,
            "message" => "API POS Abarrotes v1.0",
            "systemInfo" => getSystemInfo()
        ]);
        exit;
    }

    sendResponse(false, "Tipo de operación no especificado");
}

// Limpiar datos de entrada
if (isset($datapost)) {
    array_walk_recursive($datapost, function (&$item) {
        if (is_string($item)) {
            $item = trim($item);
        }
    });
}

// Rutas de la API
switch ($tipo) {
    // === AUTENTICACIÓN ===
    case 'login':
    case 'authenticateUser':
    case 'logout':
    case 'refreshToken':
    case 'cambiarPassword':
        include('./Auth.php');
        break;

    // === USUARIOS (Version sin auth para pruebas) ===
    case 'getUsuarios':
    case 'crearUsuario':
    case 'actualizarUsuario':
    case 'eliminarUsuario':
        // TEMPORAL: Usando version sin autenticación para pruebas
        include('./UsuariosNoAuth.php');
        break;

    // === PRODUCTOS ===
    case 'getProductos':
    case 'getProductosPaginados':
    case 'getProductosParaPrecios':
    case 'getProducto':
    case 'crearProducto':
    case 'actualizarProducto':
    case 'actualizarPrecios':
    case 'eliminarProducto':
    case 'buscarProductos':
    case 'getProductosPorCategoria':
    case 'actualizarStock':
    case 'getProductosBajoStock':
    case 'getProductosPorCodigoBarras':
    case 'importarProductos':
    case 'exportarProductos':
    case 'actualizarImpresorasMasivo':
        include('./Productos.php');
        break;

    // === EQUIVALENCIAS DE PRODUCTOS ===
    case 'getEquivalenciasProducto':
    case 'getEquivalenciasBidireccionales':
    case 'guardarEquivalenciasProducto':
    case 'eliminarEquivalencia':
        include('./ProductoEquivalencias.php');
        break;

    // === DESCUENTOS POR VOLUMEN ===
    case 'getDescuentosVolumen':
    case 'guardarDescuentosVolumen':
    case 'eliminarDescuentoVolumen':
    case 'calcularPrecioConDescuento':
    case 'getDescuentosVolumenMultiples':
    case 'updateDescuentoVolumen':
        include('./DescuentosVolumen.php');
        break;

    // === CATEGORÍAS ===
    case 'getCategorias':
    case 'getCategoria':
    case 'crearCategoria':
    case 'actualizarCategoria':
    case 'eliminarCategoria':
    case 'ordenarCategorias':
        include('./Categorias.php');
        break;

    // === VENTAS ===
    case 'crearVenta':
    case 'getVenta':
    case 'getVentas':
    case 'actualizarVenta':
    case 'actualizarEstadoVenta':
    case 'actualizarPagoVenta':
    case 'actualizarEstatusPreparacion':
    case 'reiniciarEscaneoProducto':
    case 'cancelarVenta':
    case 'finalizarVenta':
    case 'getVentasDelDia':
    case 'getVentasPorFecha':
    case 'getVentasPorCliente':
    case 'getDetalleVenta':
    case 'getUltimasVentas':
    case 'buscarVentas':
    case 'getVentasPorEstadoYAlmacen':
        include('./Ventas.php');
        break;

    // === TICKETS ===
    case 'imprimirTicket':
    case 'generarTicket':
        include('./Tickets.php');
        break;

    // === CUENTAS POR COBRAR (CXC) ===
    case 'getCuentasPorCobrar':
    case 'registrarPagoCXC':
    case 'getHistorialPagosVenta':
    case 'getResumenCXCPorCliente':
    case 'getDetalleCuentaCXC':
    case 'registrarAbonoGlobalCXC':
    case 'getCuentasPendientesCliente':
    case 'getPagosClientes':
    case 'getDetallePagoCliente':
    case 'marcarPagoFacturado':
        include('./CuentasPorCobrar.php');
        break;

    // === CLIENTES ===
    case 'getClientes':
    case 'getCliente':
    case 'crearCliente':
    case 'actualizarCliente':
    case 'eliminarCliente':
    case 'buscarClientes':
    case 'buscarClientePorTelefono':
    case 'getHistorialCliente':
    case 'getClientesFrecuentes':
        include('./Clientes.php');
        break;

    // === PROVEEDORES ===
    case 'getProveedores':
    case 'getProveedor':
    case 'crearProveedor':
    case 'actualizarProveedor':
    case 'eliminarProveedor':
    case 'buscarProveedores':
    case 'getProductosProveedor':
        include('./Proveedores.php');
        break;

    // === ÓRDENES DE COMPRA ===
    case 'getOrdenesCompra':
    case 'getOrdenCompra':
    case 'crearOrdenCompra':
    case 'actualizarOrdenCompra':
    case 'eliminarOrdenCompra':
    case 'enviarAprobacionOrden':
    case 'aprobarOrdenCompra':
    case 'rechazarOrdenCompra':
    case 'recibirOrdenCompra':
    case 'cancelarOrdenCompra':
    case 'getOrdenesCompraPorFecha':
    case 'getOrdenesCompraPorProveedor':
    case 'getOrdenesCompraPorEstado':
    // === CUENTAS POR PAGAR (CXP) ===
    case 'getCuentasPorPagar':
    case 'marcarComoPagada':
    case 'marcarVariasComoPagadas':
    case 'getResumenCXPPorProveedor':
        include('./OrdenesCompra.php');
        break;

    // === INVENTARIO ===
    case 'getInventario':
    case 'actualizarInventario':
    case 'ajusteInventario':
    case 'getMovimientosInventario':
    case 'getInventarioPorCategoria':
    case 'getAlertasStock':
    case 'exportarInventario':
    case 'importarInventario':
        include('./Inventario.php');
        break;

    // === REPORTES ===
    case 'getReporteVentas':
    case 'getReporteInventario':
    case 'getReporteProductosMasVendidos':
    case 'getReporteGanancias':
    case 'getReporteVentasPorPeriodo':
    case 'getReporteClientesFrecuentes':
    case 'getReporteMovimientosInventario':
    case 'getEstadisticasGenerales':
        include('./Reportes.php');
        break;

    // === CONFIGURACIÓN (legacy) ===
    case 'getImpresoras':
    case 'configurarImpresora':
    case 'testImpresora':
    case 'getTasaImpuesto':
    case 'actualizarTasaImpuesto':
    case 'getMoneda':
    case 'backup':
    case 'restore':
        include('./Configuraciones.php');
        break;

    // === CONFIGURACIÓN DE RANGOS DE PRECIOS ===
    case 'getConfiguracionRangos':
    case 'actualizarConfiguracionRango':
    case 'getPrecioPorCantidad':
    case 'aplicarRangosAProducto':
    case 'guardarRangosProducto':
    case 'getRangosProducto':
        include('./ConfiguracionRangos.php');
        break;

    // === SISTEMA BIOMÉTRICO ===
    case 'connectBiometric':
    case 'disconnectBiometric':
    case 'captureBiometric':
    case 'enrollBiometric':
    case 'verifyBiometric':
    case 'deleteBiometric':
    case 'getUserFingerprints':
    case 'cancelBiometric':
    case 'listBiometricDevices':
    case 'getUsuariosConHuella':
    case 'getUsuariosSinHuella':
    case 'saveFingerprintTemplate':
    case 'updateLastAuth':
        include('./Biometrico.php');
        break;

    // === DASHBOARD ===
    case 'getDashboardData':
    case 'getVentasHoy':
    case 'getProductosBajoStockCount':
    case 'getClientesCount':
    case 'getVentasUltimos30Dias':
    case 'getProductosMasVendidosHoy':
        include('./Dashboard.php');
        break;

    // === UTILIDADES ===
    case 'generarCodigoBarras':
    case 'validarCodigoBarras':
    case 'getProximoFolio':
    case 'uploadImagen':
    case 'eliminarImagen':
    case 'getImagenes':
        include('./Utilidades.php');
        break;

    // === ROLES Y PERMISOS ===
    case 'getRoles':
    case 'getRol':
    case 'crearRol':
    case 'actualizarRol':
    case 'eliminarRol':
    case 'getPermisos':
    case 'getRolPermisos':
    case 'asignarPermisos':
    case 'getUsuariosRol':
        include('./Roles.php');
        break;

    // Vehículos
    case 'getVehiculos':
    case 'crearVehiculo':
    case 'actualizarVehiculo':
    case 'eliminarVehiculo':
        include('./Vehiculos.php');
        break;

    // Rangos de Flete
    case 'getRangosFlete':
    case 'crearRangoFlete':
    case 'actualizarRangoFlete':
    case 'eliminarRangoFlete':
        include('./RangosFlete.php');
        break;

    // === ALMACENES ===
    case 'getAlmacenes':
    case 'getAlmacenById':
    case 'crearAlmacen':
    case 'actualizarAlmacen':
    case 'eliminarAlmacen':
        include('./Almacenes.php');
        break;

    // === VENTAS DE MOSTRADOR ===
    case 'crearVentaMostrador':
    case 'getVentasMostrador':
    case 'getVentaMostrador':
    case 'imprimirTicketMostrador':
    case 'buscarVentaPorFolio':
    case 'procesarDevolucion':
    case 'getReporteVentasMostrador':
    case 'getReporteVentasMostradorPorUsuario':
    case 'getReporteVentasMostradorPorCaja':
    case 'getReporteProductosMostradorMasVendidos':
    case 'getVentasMostradorDetalle':
        include('./VentasMostrador.php');
        break;

    // === CORTES DE CAJA ===
    case 'getVentasPendientesCorte':
    case 'crearCorte':
    case 'getHistorialCortes':
    case 'getDetalleCorte':
    case 'imprimirCorte':
        include('./CortesCaja.php');
        break;

    // === RETIROS DE EFECTIVO ===
    case 'verificarPermisoRetiro':
    case 'verificarPermisoDevolucion':
    case 'verificarPermisoPrecioLibre':
    case 'crearRetiroEfectivo':
    case 'getRetirosEfectivo':
    case 'getRetirosPendientesCorte':
        include('./RetirosEfectivo.php');
        break;

    // === INGRESOS DE EFECTIVO ===
    case 'verificarPermisoIngreso':
    case 'crearIngresoEfectivo':
    case 'getIngresosEfectivo':
    case 'getIngresosPendientesCorte':
        include('./IngresosEfectivo.php');
        break;

    // === RUTAS DE ENTREGA ===
    case 'getRutasEntrega':
    case 'getRutaEntrega':
    case 'crearRutaEntrega':
    case 'actualizarRutaEntrega':
    case 'eliminarRutaEntrega':
    case 'agregarPedidosARuta':
    case 'actualizarOrdenRuta':
    case 'quitarPedidoDeRuta':
    case 'getPedidosDomicilioSinRuta':
    case 'imprimirCaratula':
        include('./RutasEntrega.php');
        break;

    // === CONFIGURACIONES ===
    case 'getConfiguraciones':
    case 'getConfiguracion':
    case 'getConfiguracionesPorCategoria':
    case 'actualizarConfiguracion':
    case 'actualizarConfiguraciones':
    case 'registrarCaja':
    case 'getCajas':
    case 'getCajaPorNombrePc':
        include('./Configuraciones.php');
        break;

    // === FACTURACIÓN CFDI ===
    case 'getCatalogoRegimenFiscal':
    case 'getCatalogoUsoCFDI':
    case 'getCatalogoFormaPago':
    case 'getCatalogoMetodoPago':
    case 'getDatosFiscalesCliente':
    case 'actualizarDatosFiscales':
    case 'getVentasFacturables':
    case 'getVentasFacturablesGeneral':
    case 'getConfiguracionEmisor':
    case 'actualizarConfiguracionEmisor':
    case 'crearFactura':
    case 'getFacturas':
    case 'getFactura':
    case 'descargarFacturaXML':
    case 'descargarFacturaPDF':
    case 'reenviarFactura':
        include('./Facturacion.php');
        break;

    // === MIGRACION DE PRODUCTOS Y CLIENTES ===
    case 'probarConexionExterna':
    case 'obtenerColumnasTabla':
    case 'previewMigracion':
    case 'ejecutarMigracionProductos':
    case 'previewMigracionKerigma':
    case 'ejecutarMigracionKerigma':
    case 'previewMigracionClientesKerigma':
    case 'ejecutarMigracionClientesKerigma':
    case 'previewDiferenciaCostos':
    case 'ejecutarActualizacionCostos':
        include('./Migracion.php');
        break;

    // === PRECIOS RAY (permiso: precios_ray) ===
    case 'getProductosParaRay':
    case 'actualizarPreciosRay':
    case 'updateDescuentoVolumenRay':
        include('./PreciosRay.php');
        break;

    // === SINCRONIZACIÓN BD LOCAL ↔ NUBE ===
    case 'syncPush':
    case 'syncPushTable':
    case 'syncPull':
    case 'syncPullTable':
    case 'syncFullSync':
    case 'syncStatus':
    case 'syncLog':
        include('../sync/sync_engine.php');
        break;

    case 'syncReceive':
    case 'syncSend':
        include('../sync/sync_receive.php');
        break;

    default:
        sendResponse(false, "Operación no implementada: " . $tipo);
        break;
}
