<?php
// Script de prueba para verificar la API de flete
header("Content-Type: application/json; charset=UTF-8");

// Incluir archivos necesarios
require("./connect.php");

// Función de respuesta
function sendResponse($success, $message = '', $data = null) {
    echo json_encode([
        "success" => $success,
        "message" => $message,
        "data" => $data
    ]);
    exit;
}

try {
    echo "<h2>Pruebas de Base de Datos - Módulo Flete</h2>";

    // 1. Verificar conexión
    echo "<h3>1. Verificar conexión a BD</h3>";
    if ($conn) {
        echo "✅ Conexión exitosa<br>";
    } else {
        echo "❌ Error de conexión: " . mysqli_connect_error() . "<br>";
        exit;
    }

    // 2. Verificar si existen las tablas
    echo "<h3>2. Verificar tablas</h3>";

    $tables = ['vehiculos', 'rangos_flete'];
    foreach ($tables as $table) {
        $result = $conn->query("SHOW TABLES LIKE '$table'");
        if ($result->num_rows > 0) {
            echo "✅ Tabla '$table' existe<br>";

            // Mostrar estructura
            $structure = $conn->query("DESCRIBE $table");
            echo "<details><summary>Ver estructura de $table</summary>";
            echo "<table border='1'><tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>";
            while ($row = $structure->fetch_assoc()) {
                echo "<tr><td>{$row['Field']}</td><td>{$row['Type']}</td><td>{$row['Null']}</td><td>{$row['Key']}</td><td>{$row['Default']}</td></tr>";
            }
            echo "</table></details>";
        } else {
            echo "❌ Tabla '$table' NO existe<br>";
        }
    }

    // 3. Verificar datos
    echo "<h3>3. Verificar datos</h3>";

    // Vehículos
    $result = $conn->query("SELECT COUNT(*) as total FROM vehiculos");
    if ($result) {
        $row = $result->fetch_assoc();
        echo "📊 Vehículos en BD: {$row['total']}<br>";

        if ($row['total'] > 0) {
            $vehicles = $conn->query("SELECT * FROM vehiculos LIMIT 3");
            echo "<details><summary>Ver algunos vehículos</summary>";
            echo "<table border='1'><tr><th>ID</th><th>Nombre</th><th>Placa</th><th>Activo</th></tr>";
            while ($v = $vehicles->fetch_assoc()) {
                echo "<tr><td>{$v['id']}</td><td>{$v['nombre']}</td><td>{$v['placa']}</td><td>{$v['activo']}</td></tr>";
            }
            echo "</table></details>";
        }
    }

    // Rangos de flete
    $result = $conn->query("SELECT COUNT(*) as total FROM rangos_flete");
    if ($result) {
        $row = $result->fetch_assoc();
        echo "📊 Rangos de flete en BD: {$row['total']}<br>";

        if ($row['total'] > 0) {
            $rangos = $conn->query("SELECT r.*, v.nombre as vehiculo_nombre, v.placa FROM rangos_flete r LEFT JOIN vehiculos v ON r.vehiculo_id = v.id LIMIT 3");
            echo "<details><summary>Ver algunos rangos</summary>";
            echo "<table border='1'><tr><th>ID</th><th>Desde</th><th>Hasta</th><th>Vehículo</th><th>Costo</th><th>Activo</th></tr>";
            while ($r = $rangos->fetch_assoc()) {
                $vehiculo = $r['vehiculo_nombre'] ? "{$r['vehiculo_nombre']} ({$r['placa']})" : "Sin asignar";
                echo "<tr><td>{$r['id']}</td><td>{$r['distancia_desde']}</td><td>{$r['distancia_hasta']}</td><td>$vehiculo</td><td>\${$r['costo']}</td><td>{$r['activo']}</td></tr>";
            }
            echo "</table></details>";
        }
    }

    // 4. Probar consulta principal de la API
    echo "<h3>4. Probar consulta principal</h3>";

    $query = "SELECT r.id, r.distancia_desde, r.distancia_hasta, r.vehiculo_id, r.costo, r.activo,
                     r.fecha_creacion, r.fecha_actualizacion,
                     v.nombre as vehiculo_nombre, v.placa as vehiculo_placa
              FROM rangos_flete r
              LEFT JOIN vehiculos v ON r.vehiculo_id = v.id
              ORDER BY r.distancia_desde ASC";

    $result = $conn->query($query);
    if ($result) {
        echo "✅ Consulta principal ejecutada correctamente<br>";
        echo "📊 Registros encontrados: " . $result->num_rows . "<br>";

        if ($result->num_rows > 0) {
            echo "<details><summary>Ver resultados de consulta</summary>";
            echo "<pre>";
            $rangos = [];
            while ($row = $result->fetch_assoc()) {
                $row['activo'] = (bool)$row['activo'];
                $row['distancia_desde'] = (float)$row['distancia_desde'];
                $row['distancia_hasta'] = (float)$row['distancia_hasta'];
                $row['costo'] = (float)$row['costo'];
                $row['vehiculo_id'] = $row['vehiculo_id'] ? (int)$row['vehiculo_id'] : null;
                $rangos[] = $row;
            }
            echo json_encode($rangos, JSON_PRETTY_PRINT);
            echo "</pre></details>";
        }
    } else {
        echo "❌ Error en consulta: " . $conn->error . "<br>";
    }

    // 5. Verificar permisos
    echo "<h3>5. Verificar permisos</h3>";

    $permisos_flete = ['vehiculos_ver', 'rangos_flete_ver', 'flete_ver'];
    foreach ($permisos_flete as $permiso) {
        $result = $conn->query("SELECT * FROM permisos WHERE nombre = '$permiso'");
        if ($result && $result->num_rows > 0) {
            echo "✅ Permiso '$permiso' existe<br>";
        } else {
            echo "❌ Permiso '$permiso' NO existe<br>";
        }
    }

    echo "<h3>✅ Pruebas completadas</h3>";
    echo "<p><strong>Si todas las pruebas pasaron, la API debería funcionar correctamente.</strong></p>";

} catch (Exception $e) {
    echo "❌ Error durante las pruebas: " . $e->getMessage();
}
?>