<?php
// Script para mostrar el hash actual del usuario admin
require_once('./reportes/funciones_php/connect.php');

echo "<h2>🔍 Hash actual del usuario admin</h2>";

$query = "SELECT usuario, password FROM usuarios WHERE usuario = 'admin'";
$result = $conn->query($query);

if ($row = $result->fetch_assoc()) {
    echo "<p><strong>Usuario:</strong> " . $row['usuario'] . "</p>";
    echo "<p><strong>Hash almacenado:</strong></p>";
    echo "<code style='background: #f0f0f0; padding: 10px; display: block; word-break: break-all;'>" . htmlspecialchars($row['password']) . "</code>";

    // Mostrar longitud del hash
    echo "<p><strong>Longitud del hash:</strong> " . strlen($row['password']) . " caracteres</p>";

    // Verificar si es un hash válido de bcrypt
    $is_bcrypt = substr($row['password'], 0, 4) === '$2y$';
    echo "<p><strong>Formato bcrypt:</strong> " . ($is_bcrypt ? "✅ Sí" : "❌ No") . "</p>";

    echo "<hr>";
    echo "<h3>🔄 Nuevo hash correcto para 'admin123':</h3>";

    // Generar nuevo hash
    $new_hash = password_hash('admin123', PASSWORD_BCRYPT);
    echo "<code style='background: #e8f5e8; padding: 10px; display: block; word-break: break-all;'>" . htmlspecialchars($new_hash) . "</code>";

    echo "<h3>📝 Query para actualizar:</h3>";
    echo "<code style='background: #fff3cd; padding: 10px; display: block;'>";
    echo "UPDATE usuarios SET password = '" . $new_hash . "' WHERE usuario = 'admin';";
    echo "</code>";

    echo "<hr>";
    echo "<h3>🧪 Prueba de verificación:</h3>";
    $test_verify = password_verify('admin123', $row['password']);
    echo "<p>password_verify('admin123', hash_actual): <strong>" . ($test_verify ? "✅ CORRECTO" : "❌ INCORRECTO") . "</strong></p>";

} else {
    echo "<p>❌ Usuario 'admin' no encontrado</p>";
}

echo "<hr>";
echo "<p><small>Fecha: " . date('Y-m-d H:i:s') . "</small></p>";
?>