<?php
class EncryptClass {
    private $secret_key;
    private $secret_iv;
    private $encrypt_method;

    public function __construct() {
        $this->secret_key = 'POS_ABARROTES_SECRET_KEY_2024';
        $this->secret_iv = 'POS_ABARROTES_SECRET_IV_2024';
        $this->encrypt_method = "AES-256-CBC";
    }

    public function encrypt($string) {
        $key = hash('sha256', $this->secret_key);
        $iv = substr(hash('sha256', $this->secret_iv), 0, 16);
        $encrypted = openssl_encrypt($string, $this->encrypt_method, $key, 0, $iv);
        return base64_encode($encrypted);
    }

    public function decrypt($string) {
        $key = hash('sha256', $this->secret_key);
        $iv = substr(hash('sha256', $this->secret_iv), 0, 16);
        $decrypted = openssl_decrypt(base64_decode($string), $this->encrypt_method, $key, 0, $iv);
        return $decrypted;
    }

    public function hashPassword($password) {
        return password_hash($password, PASSWORD_BCRYPT);
    }

    public function verifyPassword($password, $hash) {
        return password_verify($password, $hash);
    }

    public function generateToken($length = 32) {
        return bin2hex(random_bytes($length));
    }

    public function generateSecureId() {
        return uniqid(mt_rand(), true);
    }
}
?>